/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.commands;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.commands.IndexingCommands;
import org.nuxeo.runtime.api.Framework;

public abstract class IndexingCommandsStacker {
    protected static final Log log = LogFactory.getLog(IndexingCommandsStacker.class);

    protected abstract Map<String, IndexingCommands> getAllCommands();

    protected abstract boolean isSyncIndexingByDefault();

    protected IndexingCommands getCommands(DocumentModel doc) {
        return this.getAllCommands().get(this.getDocKey(doc));
    }

    public void stackCommand(DocumentEventContext docCtx, String eventId) {
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc == null) {
            return;
        }
        if ("/".equals(doc.getPathAsString())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Skip indexing command for root document");
            }
            if (eventId.equals("documentSecurityUpdated")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Indexing root document children to update their permissions");
                }
                DocumentModelList children = doc.getCoreSession().getChildren(doc.getRef());
                children.forEach(child -> this.stackCommand((DocumentModel)child, docCtx, eventId));
            }
        } else {
            this.stackCommand(doc, docCtx, eventId);
        }
    }

    protected void stackCommand(DocumentModel doc, DocumentEventContext docCtx, String eventId) {
        Boolean block = (Boolean)docCtx.getProperty("disableAutoIndexing");
        if (block != null && block.booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Indexing is disable, skip indexing command for doc " + doc));
            }
            return;
        }
        boolean sync = this.isSynchronous(docCtx, doc);
        this.stackCommand(doc, eventId, sync);
    }

    protected boolean isSynchronous(DocumentEventContext docCtx, DocumentModel doc) {
        Boolean sync = (Boolean)docCtx.getProperty("ESSyncIndexing");
        if (sync != null) {
            return sync;
        }
        sync = (Boolean)doc.getContextData("ESSyncIndexing");
        if (sync != null) {
            return sync;
        }
        sync = this.isSyncIndexingByDefault();
        return sync;
    }

    protected void stackCommand(DocumentModel doc, String eventId, boolean sync) {
        IndexingCommand.Type type;
        IndexingCommands cmds = this.getOrCreateCommands(doc);
        boolean recurse = false;
        switch (eventId) {
            case "documentCreated": 
            case "documentImported": {
                type = IndexingCommand.Type.INSERT;
                break;
            }
            case "documentCreatedByCopy": {
                type = IndexingCommand.Type.INSERT;
                recurse = this.isFolderish(doc);
                break;
            }
            case "beforeDocumentModification": 
            case "documentCheckedIn": 
            case "documentCheckedOut": 
            case "binaryTextUpdated": 
            case "documentTagUpdated": 
            case "documentProxyUpdated": 
            case "lifecycle_transition_event": 
            case "documentTrashed": 
            case "documentUntrashed": 
            case "documentRestored": 
            case "afterMakeRecord": 
            case "afterSetRetention": 
            case "afterExtendRetention": 
            case "afterSetLegalHold": 
            case "afterRemoveLegalHold": {
                if (doc.isProxy() && !doc.isImmutable()) {
                    this.stackCommand(doc.getCoreSession().getDocument((DocumentRef)new IdRef(doc.getSourceId())), "beforeDocumentModification", false);
                }
                type = IndexingCommand.Type.UPDATE;
                break;
            }
            case "aboutToCheckIn": {
                if (this.indexIsLatestVersion()) {
                    String query = String.format("SELECT * FROM %s WHERE (ecm:isLatestMajorVersion = 1 OR ecm:isLatestVersion = 1) AND ecm:versionVersionableId= '%s'", doc.getType(), doc.getId());
                    DocumentModelList versions = doc.getCoreSession().query(query);
                    for (DocumentModel version : versions) {
                        this.stackCommand(version, "beforeDocumentModification", false);
                    }
                }
                type = IndexingCommand.Type.UPDATE;
                break;
            }
            case "documentMoved": {
                type = IndexingCommand.Type.UPDATE;
                recurse = this.isFolderish(doc);
                break;
            }
            case "documentRemoved": {
                type = IndexingCommand.Type.DELETE;
                recurse = this.isFolderish(doc);
                break;
            }
            case "documentSecurityUpdated": {
                type = IndexingCommand.Type.UPDATE_SECURITY;
                recurse = this.isFolderish(doc);
                break;
            }
            case "childrenOrderChanged": {
                type = IndexingCommand.Type.UPDATE_DIRECT_CHILDREN;
                recurse = true;
                break;
            }
            default: {
                return;
            }
        }
        if (sync && recurse) {
            cmds.add(type, true, false);
            cmds.add(type, false, true);
        } else {
            cmds.add(type, sync, recurse);
        }
    }

    private boolean indexIsLatestVersion() {
        return !Framework.isBooleanPropertyTrue((String)"org.nuxeo.core.isLatestVersion.disabled");
    }

    private boolean isFolderish(DocumentModel doc) {
        return doc.isFolder() && !doc.isVersion();
    }

    protected IndexingCommands getOrCreateCommands(DocumentModel doc) {
        IndexingCommands cmds = this.getCommands(doc);
        if (cmds == null) {
            cmds = new IndexingCommands(doc);
            this.getAllCommands().put(this.getDocKey(doc), cmds);
        }
        return cmds;
    }

    protected String getDocKey(DocumentModel doc) {
        return doc.getId();
    }
}

