/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.Aggregate;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.api.Bucket;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.QuickFilter;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;
import org.nuxeo.elasticsearch.aggregate.AggregateFactory;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.api.EsResult;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.query.PageProviderQueryBuilder;
import org.nuxeo.runtime.api.Framework;

public class ElasticSearchNativePageProvider
extends AbstractPageProvider<DocumentModel> {
    public static final String CORE_SESSION_PROPERTY = "coreSession";
    public static final String SEARCH_ON_ALL_REPOSITORIES_PROPERTY = "searchAllRepositories";
    protected static final Log log = LogFactory.getLog(ElasticSearchNativePageProvider.class);
    private static final long serialVersionUID = 1L;
    protected List<DocumentModel> currentPageDocuments;
    protected Map<String, Aggregate<? extends Bucket>> currentAggregates;

    public Map<String, Aggregate<? extends Bucket>> getAggregates() {
        this.getCurrentPage();
        return this.currentAggregates;
    }

    public List<DocumentModel> getCurrentPage() {
        long t0 = System.currentTimeMillis();
        if (this.currentPageDocuments != null) {
            return this.currentPageDocuments;
        }
        this.error = null;
        this.errorMessage = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Perform query for provider '%s': with pageSize=%d, offset=%d", this.getName(), this.getMinMaxPageSize(), this.getCurrentPageOffset()));
        }
        this.currentPageDocuments = new ArrayList<DocumentModel>();
        QueryBuilder query = this.makeQueryBuilder();
        SortInfo[] sortArray = null;
        if (this.sortInfos != null) {
            sortArray = this.sortInfos.toArray(new SortInfo[this.sortInfos.size()]);
        }
        ElasticSearchService ess = (ElasticSearchService)Framework.getService(ElasticSearchService.class);
        try {
            List highlightFields;
            NxQueryBuilder nxQuery = new NxQueryBuilder(this.getCoreSession()).esQuery(query).offset((int)this.getCurrentPageOffset()).limit((int)this.getMinMaxPageSize()).addSort(sortArray).addAggregates(this.buildAggregates());
            if (this.searchOnAllRepositories()) {
                nxQuery.searchOnAllRepositories();
            }
            if ((highlightFields = this.getHighlights()) != null && !highlightFields.isEmpty()) {
                nxQuery.highlight(highlightFields);
            }
            EsResult ret = ess.queryAndAggregate(nxQuery);
            DocumentModelList dmList = ret.getDocuments();
            this.currentAggregates = new HashMap<String, Aggregate<? extends Bucket>>(ret.getAggregates().size());
            for (Aggregate<Bucket> agg : ret.getAggregates()) {
                this.currentAggregates.put(agg.getId(), agg);
            }
            this.setResultsCount(dmList.totalSize());
            this.currentPageDocuments = dmList;
        }
        catch (QueryParseException e) {
            this.error = e;
            this.errorMessage = e.getMessage();
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        this.fireSearchEvent(this.getCoreSession().getPrincipal(), query.toString(), this.currentPageDocuments, System.currentTimeMillis() - t0);
        return this.currentPageDocuments;
    }

    private List<AggregateEsBase<? extends Aggregation, ? extends Bucket>> buildAggregates() {
        ArrayList<AggregateEsBase<? extends Aggregation, ? extends Bucket>> ret = new ArrayList<AggregateEsBase<? extends Aggregation, ? extends Bucket>>(this.getAggregateDefinitions().size());
        boolean skip = this.isSkipAggregates();
        for (AggregateDefinition def : this.getAggregateDefinitions()) {
            AggregateEsBase<? extends Aggregation, ? extends Bucket> agg = AggregateFactory.create(def, this.getSearchDocumentModel());
            if (skip && agg.getSelection().isEmpty()) continue;
            ret.add(AggregateFactory.create(def, this.getSearchDocumentModel()));
        }
        return ret;
    }

    public boolean hasAggregateSupport() {
        return true;
    }

    protected QueryBuilder makeQueryBuilder() {
        QueryBuilder ret;
        WhereClauseDefinition whereClause;
        PageProviderDefinition def = this.getDefinition();
        List quickFilters = this.getQuickFilters();
        String quickFiltersClause = "";
        if (quickFilters != null && !quickFilters.isEmpty()) {
            for (QuickFilter quickFilter : quickFilters) {
                String clause = quickFilter.getClause();
                if (!quickFiltersClause.isEmpty() && clause != null) {
                    quickFiltersClause = NXQLQueryBuilder.appendClause((String)quickFiltersClause, (String)clause);
                    continue;
                }
                quickFiltersClause = clause != null ? clause : "";
            }
        }
        if ((whereClause = def.getWhereClause()) == null) {
            String originalPattern = def.getPattern();
            String pattern = quickFiltersClause.isEmpty() ? originalPattern : (StringUtils.containsIgnoreCase((CharSequence)originalPattern, (CharSequence)" WHERE ") ? NXQLQueryBuilder.appendClause((String)originalPattern, (String)quickFiltersClause) : originalPattern + " WHERE " + quickFiltersClause);
            ret = PageProviderQueryBuilder.makeQuery(pattern, this.getParameters(), def.getQuotePatternParameters(), def.getEscapePatternParameters(), this.isNativeQuery());
        } else {
            DocumentModel searchDocumentModel = this.getSearchDocumentModel();
            if (searchDocumentModel == null) {
                throw new NuxeoException(String.format("Cannot build query of provider '%s': no search document model is set", this.getName()));
            }
            ret = PageProviderQueryBuilder.makeQuery(searchDocumentModel, whereClause, quickFiltersClause, this.getParameters(), this.isNativeQuery());
        }
        return ret;
    }

    protected void pageChanged() {
        this.currentPageDocuments = null;
        this.currentAggregates = null;
        super.pageChanged();
    }

    public void refresh() {
        this.currentPageDocuments = null;
        this.currentAggregates = null;
        super.refresh();
    }

    protected CoreSession getCoreSession() {
        Map props = this.getProperties();
        CoreSession coreSession = (CoreSession)props.get(CORE_SESSION_PROPERTY);
        if (coreSession == null) {
            throw new NuxeoException("cannot find core session");
        }
        return coreSession;
    }

    protected boolean searchOnAllRepositories() {
        String value = (String)this.getProperties().get(SEARCH_ON_ALL_REPOSITORIES_PROPERTY);
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public boolean isNativeQuery() {
        return true;
    }
}

