/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.coldstorage;

import java.time.Duration;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.blob.ColdStorageHelper;
import org.nuxeo.ecm.platform.notification.api.NotificationManager;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.RequestRetrievalFromColdStorage", category="Files", label="Request retrieval from cold storage", description="Request a retrieval from cold storage of the content associated with the document.")
public class RequestRetrievalFromColdStorage {
    public static final String ID = "Document.RequestRetrievalFromColdStorage";
    @Param(name="numberOfDaysOfAvailability", description="The number of days that you want your cold storage content to be accessible.")
    protected int numberOfDaysOfAvailability;
    @Context
    protected CoreSession session;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        DocumentModel documentModel = ColdStorageHelper.requestRetrievalFromColdStorage((CoreSession)this.session, (DocumentRef)doc.getRef(), (Duration)Duration.ofDays(this.numberOfDaysOfAvailability));
        NuxeoPrincipal principal = this.session.getPrincipal();
        String username = "user:" + principal.getName();
        NotificationManager notificationManager = (NotificationManager)Framework.getService(NotificationManager.class);
        notificationManager.addSubscription(username, "ColdStorageContentAvailable", documentModel, Boolean.valueOf(false), principal, "ColdStorageContentAvailable");
        if (this.save) {
            documentModel = this.session.saveDocument(documentModel);
        }
        return documentModel;
    }
}

