/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Comparator;

public class ACLRow
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final int pos;
    public final String name;
    public final boolean grant;
    public final String permission;
    public final String user;
    public final String group;
    public final Calendar begin;
    public final Calendar end;
    public final String creator;
    public final Long status;

    public ACLRow(int pos, String name, boolean grant, String permission, String user, String group, String creator, Calendar begin, Calendar end, Long status) {
        this.pos = pos;
        this.name = name;
        this.grant = grant;
        this.permission = permission;
        this.user = user;
        this.group = group;
        this.creator = creator;
        this.begin = begin;
        this.end = end;
        this.status = status;
    }

    public ACLRow(int pos, String name, boolean grant, String permission, String user, String group) {
        this(pos, name, grant, permission, user, group, null, null, null, null);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.pos + "," + this.name + "," + (this.grant ? "GRANT" : "DENY") + "," + this.permission + "," + this.user + "," + this.group + "," + this.begin + "," + this.end + "44" + this.status + ")";
    }

    public static class ACLRowPositionComparator
    implements Comparator<ACLRow> {
        public static final ACLRowPositionComparator INSTANCE = new ACLRowPositionComparator();

        @Override
        public int compare(ACLRow acl1, ACLRow acl2) {
            return acl1.pos - acl2.pos;
        }
    }
}

