/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.SelectionType;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;
import org.nuxeo.ecm.core.storage.sql.VCSInvalidations;

public interface RowMapper {
    public Serializable generateNewId();

    public List<? extends RowId> read(Collection<RowId> var1, boolean var2);

    public void write(RowBatch var1);

    public Row readSimpleRow(RowId var1);

    public Map<String, String> getBinaryFulltext(RowId var1);

    public Serializable[] readCollectionRowArray(RowId var1);

    public List<Row> readSelectionRows(SelectionType var1, Serializable var2, Serializable var3, Serializable var4, boolean var5);

    public Set<Serializable> readSelectionsIds(SelectionType var1, List<Serializable> var2);

    public CopyResult copy(IdWithTypes var1, Serializable var2, String var3, Row var4, boolean var5);

    public List<NodeInfo> getDescendantsInfo(Serializable var1);

    public void remove(Serializable var1, List<NodeInfo> var2);

    public VCSInvalidations receiveInvalidations();

    public void sendInvalidations(VCSInvalidations var1);

    public void clearCache();

    public long getCacheSize();

    public void rollback(Xid var1) throws XAException;

    public static final class NodeInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Serializable id;
        public final Serializable parentId;
        public final String primaryType;
        public final Boolean isProperty;
        public final Serializable versionSeriesId;
        public final Serializable targetId;
        public final boolean isRecord;
        public final boolean isUndeletable;

        public NodeInfo(Serializable id, Serializable parentId, String primaryType, Boolean isProperty, Serializable versionSeriesId, Serializable targetId, boolean isRecord, Calendar retainUntil, boolean hasLegalHold, boolean isRetentionActive) {
            this.id = id;
            this.parentId = parentId;
            this.primaryType = primaryType;
            this.isProperty = isProperty;
            this.versionSeriesId = versionSeriesId;
            this.targetId = targetId;
            this.isRecord = isRecord;
            this.isUndeletable = hasLegalHold || retainUntil != null && Calendar.getInstance().before(retainUntil) || isRetentionActive;
        }

        public NodeInfo(SimpleFragment hierFragment, SimpleFragment versionFragment, SimpleFragment proxyFragment) {
            Serializable ps;
            this.id = hierFragment.getId();
            this.parentId = hierFragment.get("parentid");
            this.primaryType = hierFragment.getString("primarytype");
            this.isProperty = (Boolean)hierFragment.get("isproperty");
            Serializable serializable = ps = proxyFragment == null ? null : proxyFragment.get("versionableid");
            if (ps == null) {
                this.versionSeriesId = versionFragment == null ? null : versionFragment.get("versionableid");
                this.targetId = null;
            } else {
                this.versionSeriesId = ps;
                this.targetId = proxyFragment.get("targetid");
            }
            this.isRecord = Boolean.TRUE.equals(hierFragment.get("isrecord"));
            Serializable hasLegalHold = hierFragment.get("haslegalhold");
            Serializable retainUntil = hierFragment.get("retainuntil");
            Serializable isRetentionActive = hierFragment.get("isretentionactive");
            this.isUndeletable = Boolean.TRUE.equals(hasLegalHold) || retainUntil != null && Calendar.getInstance().before(retainUntil) || Boolean.TRUE.equals(isRetentionActive);
        }
    }

    public static final class CopyResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Serializable copyId;
        public final VCSInvalidations invalidations;
        public final Set<Serializable> proxyIds;
        public final Set<Serializable> recordIds;

        public CopyResult(Serializable copyId, VCSInvalidations invalidations, Set<Serializable> proxyIds, Set<Serializable> recordIds) {
            this.copyId = copyId;
            this.invalidations = invalidations;
            this.proxyIds = proxyIds;
            this.recordIds = recordIds;
        }
    }

    public static final class IdWithTypes
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Serializable id;
        public final String primaryType;
        public final String[] mixinTypes;
        public final boolean isRecord;

        public IdWithTypes(Serializable id, String primaryType, String[] mixinTypes, boolean isRecord) {
            this.id = id;
            this.primaryType = primaryType;
            this.mixinTypes = mixinTypes;
            this.isRecord = isRecord;
        }

        public IdWithTypes(Node node) {
            this(node.getId(), node.getPrimaryType(), node.getMixinTypes(), node.isRecord());
        }

        public IdWithTypes(NodeInfo info) {
            this(info.id, info.primaryType, null, info.isRecord);
        }

        public IdWithTypes(SimpleFragment hierFragment) {
            this(hierFragment.getId(), hierFragment.getString("primarytype"), (String[])hierFragment.get("mixintypes"), Boolean.TRUE.equals(hierFragment.get("isrecord")));
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(id=" + this.id + ",primaryType=" + this.primaryType + ",mixinTypes=" + Arrays.toString(this.mixinTypes) + ")";
        }
    }

    public static class RowBatch
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final List<Row> creates = new LinkedList<Row>();
        public final Set<RowUpdate> updates = new HashSet<RowUpdate>();
        public final Set<RowId> deletes = new HashSet<RowId>();
        public final Set<RowId> deletesDependent = new HashSet<RowId>();

        public boolean isEmpty() {
            return this.creates.isEmpty() && this.updates.isEmpty() && this.deletes.isEmpty() && this.deletesDependent.isEmpty();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(creates=" + this.creates + ", updates=" + this.updates + ", deletes=" + this.deletes + ", deletesDependent=" + this.deletesDependent + ")";
        }
    }

    public static final class RowUpdate
    implements Serializable,
    Comparable<RowUpdate> {
        private static final long serialVersionUID = 1L;
        public final Row row;
        public final Collection<String> keys;
        public final int pos;
        public Map<String, Serializable> conditions;

        public RowUpdate(Row row, Collection<String> keys) {
            this.row = row;
            this.keys = keys;
            this.pos = -1;
        }

        public RowUpdate(Row row) {
            this(row, -1);
        }

        public RowUpdate(Row row, int pos) {
            this.row = row;
            this.keys = null;
            this.pos = pos;
        }

        public void setConditions(Map<String, Serializable> conditions) {
            this.conditions = conditions;
        }

        public int hashCode() {
            return this.row.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof RowUpdate) {
                return ((RowUpdate)other).row.equals(this.row);
            }
            return false;
        }

        @Override
        public int compareTo(RowUpdate other) {
            return this.row.compareTo(other.row);
        }

        public String toString() {
            String string = this.getClass().getSimpleName() + "(" + this.row + ", keys=" + this.keys + ")";
            if (this.conditions != null && !this.conditions.isEmpty()) {
                string = string + "(IF=" + this.conditions + ")";
            }
            return string;
        }
    }
}

