/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.LifeCycleException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.core.blob.DocumentBlobManager;
import org.nuxeo.ecm.core.lifecycle.LifeCycle;
import org.nuxeo.ecm.core.lifecycle.LifeCycleService;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.storage.BaseDocument;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocument;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;
import org.nuxeo.runtime.api.Framework;

public class SQLDocumentLive
extends BaseDocument<Node>
implements SQLDocument {
    protected final Node node;
    protected final Type type;
    protected SQLSession session;
    protected final List<Schema> proxySchemas;
    protected boolean readonly;
    protected static final Map<String, String> systemPropNameMap = new HashMap<String, String>();

    protected SQLDocumentLive(Node node, ComplexType type, SQLSession session, boolean readonly) {
        this.node = node;
        this.type = type;
        this.session = session;
        if (node != null && node.isProxy()) {
            SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            this.proxySchemas = schemaManager.getProxySchemas(type.getName());
        } else {
            this.proxySchemas = null;
        }
        this.readonly = readonly;
    }

    public void setReadOnly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    public String getName() {
        return this.getNode() == null ? null : this.getNode().getName();
    }

    public Long getPos() {
        return this.getNode().getPos();
    }

    public DocumentType getType() {
        return (DocumentType)this.type;
    }

    public SQLSession getSession() {
        return this.session;
    }

    public boolean isFolder() {
        return this.type == null || ((DocumentType)this.type).isFolder();
    }

    public String getUUID() {
        return this.session.idToString(this.getNode().getId());
    }

    public Document getParent() {
        return this.session.getParent(this.getNode());
    }

    public String getPath() {
        return this.session.getPath(this.getNode());
    }

    public boolean isProxy() {
        return false;
    }

    public String getRepositoryName() {
        return this.session.getRepositoryName();
    }

    protected List<Schema> getProxySchemas() {
        return this.proxySchemas;
    }

    public void remove() {
        this.session.remove(this.getNode());
    }

    public void remove(NuxeoPrincipal principal) {
        this.remove();
    }

    public void removeSingleton() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void readDocumentPart(DocumentPart dp) throws PropertyException {
        this.readComplexProperty(this.getNode(), (ComplexProperty)dp);
    }

    public boolean writeDocumentPart(DocumentPart dp, Document.WriteContext writeContext) throws PropertyException {
        boolean changed = this.writeComplexProperty(this.getNode(), (ComplexProperty)dp, writeContext);
        SQLDocumentLive.clearDirtyFlags((Property)dp);
        return changed;
    }

    protected Node getChild(Node node, String name, Type type) throws PropertyException {
        return this.session.getChildProperty(node, name, type.getName());
    }

    protected Node getChildForWrite(Node node, String name, Type type) throws PropertyException {
        return this.session.getChildPropertyForWrite(node, name, type.getName());
    }

    protected List<Node> getChildAsList(Node node, String name) throws PropertyException {
        return this.session.getComplexList(node, name);
    }

    protected void updateList(Node node, String name, Field field, String xpath, List<Object> values) throws PropertyException {
        int i;
        int newSize;
        List<Node> childNodes = this.getChildAsList(node, name);
        int oldSize = childNodes.size();
        if (oldSize > (newSize = values.size())) {
            for (i = oldSize - 1; i >= newSize; --i) {
                this.session.removeProperty(childNodes.remove(i));
            }
        }
        if (oldSize < newSize) {
            String typeName = field.getType().getName();
            for (int i2 = oldSize; i2 < newSize; ++i2) {
                Node childNode = this.session.addChildProperty(node, name, Long.valueOf(i2), typeName);
                childNodes.add(childNode);
            }
        }
        i = 0;
        for (Object v : values) {
            Node childNode = childNodes.get(i);
            this.setValueComplex(childNode, field, xpath + "/" + i, v);
            ++i;
        }
    }

    protected List<Node> updateList(Node node, String name, Property property) throws PropertyException {
        int newSize;
        Collection properties = property.getChildren();
        List<Node> childNodes = this.getChildAsList(node, name);
        int oldSize = childNodes.size();
        if (oldSize > (newSize = properties.size())) {
            for (int i = oldSize - 1; i >= newSize; --i) {
                this.session.removeProperty(childNodes.remove(i));
            }
        }
        if (oldSize < newSize) {
            String typeName = ((ListType)property.getType()).getFieldType().getName();
            for (int i = oldSize; i < newSize; ++i) {
                Node childNode = this.session.addChildProperty(node, name, Long.valueOf(i), typeName);
                childNodes.add(childNode);
            }
        }
        return childNodes;
    }

    protected String internalName(String name) {
        return name;
    }

    public Object getValue(String xpath) throws PropertyException {
        return this.getValueObject(this.getNode(), xpath);
    }

    public void setValue(String xpath, Object value) throws PropertyException {
        this.setValueObject(this.getNode(), xpath, value);
    }

    public void visitBlobs(Consumer<Document.BlobAccessor> blobVisitor) throws PropertyException {
        this.visitBlobs(this.getNode(), blobVisitor, NO_DIRTY);
    }

    public Serializable getPropertyValue(String name) {
        return this.getNode().getSimpleProperty(name).getValue();
    }

    public void setPropertyValue(String name, Serializable value) {
        this.getNode().setSimpleProperty(name, value);
    }

    public void setSystemProp(String name, Serializable value) {
        String propertyName;
        if (name.startsWith("fulltextSimple")) {
            propertyName = name.replace("fulltextSimple", "ecm:fulltextSimple");
            if (this.session.isFulltextStoredInBlob()) {
                return;
            }
        } else if (name.startsWith("fulltextBinary")) {
            propertyName = name.replace("fulltextBinary", "ecm:fulltextBinary");
            if (this.session.isFulltextStoredInBlob()) {
                if (!(value instanceof String)) {
                    throw new PropertyException("Property " + name + " must be a string");
                }
                this.setPropertyBlobData(propertyName, (String)((Object)value));
                return;
            }
        } else {
            propertyName = systemPropNameMap.get(name);
        }
        if (propertyName == null) {
            throw new PropertyNotFoundException(name, "Unknown system property");
        }
        this.setPropertyValue(propertyName, value);
    }

    public <T extends Serializable> T getSystemProp(String name, Class<T> type) {
        String propertyName = systemPropNameMap.get(name);
        if (propertyName == null) {
            throw new PropertyNotFoundException(name, "Unknown system property");
        }
        Serializable value = this.getPropertyValue(propertyName);
        if (value == null) {
            if (type == Boolean.class) {
                value = Boolean.FALSE;
            } else if (type == Long.class) {
                value = Long.valueOf(0L);
            }
        }
        return (T)value;
    }

    public String getChangeToken() {
        Calendar modified;
        if (this.session.isChangeTokenEnabled()) {
            Long sysChangeToken = (Long)this.getPropertyValue("ecm:systemChangeToken");
            Long changeToken = (Long)this.getPropertyValue("ecm:changeToken");
            return SQLDocumentLive.buildUserVisibleChangeToken((Long)sysChangeToken, (Long)changeToken);
        }
        try {
            modified = (Calendar)this.getPropertyValue("dc:modified");
        }
        catch (PropertyNotFoundException e) {
            modified = null;
        }
        return this.getLegacyChangeToken(modified);
    }

    public boolean validateUserVisibleChangeToken(String userVisibleChangeToken) {
        Calendar modified;
        if (userVisibleChangeToken == null) {
            return true;
        }
        if (this.session.isChangeTokenEnabled()) {
            Long sysChangeToken = (Long)this.getPropertyValue("ecm:systemChangeToken");
            Long changeToken = (Long)this.getPropertyValue("ecm:changeToken");
            return SQLDocumentLive.validateUserVisibleChangeToken((Long)sysChangeToken, (Long)changeToken, (String)userVisibleChangeToken);
        }
        try {
            modified = (Calendar)this.getPropertyValue("dc:modified");
        }
        catch (PropertyNotFoundException e) {
            modified = null;
        }
        return this.validateLegacyChangeToken(modified, userVisibleChangeToken);
    }

    public void markUserChange() {
        this.session.markUserChange(this.getNode().getId());
    }

    protected DocumentBlobManager getDocumentBlobManager() {
        return (DocumentBlobManager)Framework.getService(DocumentBlobManager.class);
    }

    public void makeRecord() {
        this.setPropertyValue("ecm:isRecord", Boolean.TRUE);
        this.getDocumentBlobManager().notifyMakeRecord((Document)this);
    }

    public boolean isRecord() {
        return Boolean.TRUE.equals(this.getPropertyValue("ecm:isRecord"));
    }

    public void setRetainUntil(Calendar retainUntil) {
        Calendar current = (Calendar)this.getPropertyValue("ecm:retainUntil");
        if (!this.allowNewRetention(current, retainUntil)) {
            throw new PropertyException("Cannot reduce retention time from: " + (Serializable)(current == null ? "null" : current.toInstant()) + " to: " + (Serializable)(retainUntil == null ? "null" : retainUntil.toInstant()));
        }
        this.setPropertyValue("ecm:retainUntil", retainUntil);
        this.getDocumentBlobManager().notifySetRetainUntil((Document)this, retainUntil);
    }

    public Calendar getRetainUntil() {
        return (Calendar)this.getPropertyValue("ecm:retainUntil");
    }

    public void setLegalHold(boolean hold) {
        this.setPropertyValue("ecm:hasLegalHold", hold ? Boolean.TRUE : null);
        this.getDocumentBlobManager().notifySetLegalHold((Document)this, hold);
    }

    public boolean hasLegalHold() {
        return Boolean.TRUE.equals(this.getPropertyValue("ecm:hasLegalHold"));
    }

    public void setRetentionActive(boolean retentionActive) {
        this.setPropertyValue("ecm:isRetentionActive", retentionActive ? Boolean.TRUE : null);
    }

    public boolean isRetentionActive() {
        return Boolean.TRUE.equals(this.getPropertyValue("ecm:isRetentionActive"));
    }

    public String getLifeCyclePolicy() {
        return (String)((Object)this.getPropertyValue("ecm:lifeCyclePolicy"));
    }

    public void setLifeCyclePolicy(String policy) {
        this.setPropertyValue("ecm:lifeCyclePolicy", (Serializable)((Object)policy));
        this.getDocumentBlobManager().notifyChanges((Document)this, Collections.singleton("ecm:lifeCyclePolicy"));
    }

    public String getLifeCycleState() {
        return (String)((Object)this.getPropertyValue("ecm:lifeCycleState"));
    }

    public void setCurrentLifeCycleState(String state) {
        this.setPropertyValue("ecm:lifeCycleState", (Serializable)((Object)state));
        this.getDocumentBlobManager().notifyChanges((Document)this, Collections.singleton("ecm:lifeCycleState"));
    }

    public void followTransition(String transition) throws LifeCycleException {
        LifeCycleService service = (LifeCycleService)Framework.getService(LifeCycleService.class);
        if (service == null) {
            throw new NuxeoException("LifeCycleService not available");
        }
        service.followTransition((Document)this, transition);
    }

    public Collection<String> getAllowedStateTransitions() {
        LifeCycleService service = (LifeCycleService)Framework.getService(LifeCycleService.class);
        if (service == null) {
            throw new NuxeoException("LifeCycleService not available");
        }
        LifeCycle lifeCycle = service.getLifeCycleFor((Document)this);
        if (lifeCycle == null) {
            return Collections.emptyList();
        }
        return lifeCycle.getAllowedStateTransitionsFrom(this.getLifeCycleState());
    }

    public boolean isVersion() {
        return false;
    }

    public Document getBaseVersion() {
        if (this.isCheckedOut()) {
            return null;
        }
        Serializable id = this.getPropertyValue("ecm:baseVersion");
        if (id == null) {
            return null;
        }
        return this.session.getDocumentById(id);
    }

    public String getVersionSeriesId() {
        return this.getUUID();
    }

    public Document getSourceDocument() {
        return this;
    }

    public Document checkIn(String label, String checkinComment) {
        if (this.isRecord()) {
            throw new PropertyException("Record cannot be checked in: " + this.getUUID());
        }
        Document version = this.session.checkIn(this.getNode(), label, checkinComment);
        this.getDocumentBlobManager().freezeVersion(version);
        return version;
    }

    public void checkOut() {
        this.session.checkOut(this.getNode());
    }

    public boolean isCheckedOut() {
        return !Boolean.TRUE.equals(this.getPropertyValue("ecm:isCheckedIn"));
    }

    public boolean isMajorVersion() {
        return false;
    }

    public boolean isLatestVersion() {
        return false;
    }

    public boolean isLatestMajorVersion() {
        return false;
    }

    public boolean isVersionSeriesCheckedOut() {
        return this.isCheckedOut();
    }

    public String getVersionLabel() {
        return (String)((Object)this.getPropertyValue("ecm:versionLabel"));
    }

    public String getCheckinComment() {
        return (String)((Object)this.getPropertyValue("ecm:versionDescription"));
    }

    public Document getWorkingCopy() {
        return this;
    }

    public Calendar getVersionCreationDate() {
        return (Calendar)this.getPropertyValue("ecm:versionCreated");
    }

    public void restore(Document version) {
        if (!version.isVersion()) {
            throw new NuxeoException("Cannot restore a non-version: " + version);
        }
        this.session.restore(this.getNode(), ((SQLDocument)version).getNode());
    }

    public List<String> getVersionsIds() {
        String versionSeriesId = this.getVersionSeriesId();
        List<Document> versions = this.session.getVersions(versionSeriesId);
        ArrayList<String> ids = new ArrayList<String>(versions.size());
        for (Document version : versions) {
            ids.add(version.getUUID());
        }
        return ids;
    }

    public Document getVersion(String label) {
        String versionSeriesId = this.getVersionSeriesId();
        return this.session.getVersionByLabel(versionSeriesId, label);
    }

    public List<Document> getVersions() {
        String versionSeriesId = this.getVersionSeriesId();
        return this.session.getVersions(versionSeriesId);
    }

    public Document getLastVersion() {
        String versionSeriesId = this.getVersionSeriesId();
        return this.session.getLastVersion(versionSeriesId);
    }

    public Document getChild(String name) {
        return this.session.getChild(this.getNode(), name);
    }

    public List<Document> getChildren() {
        return this.session.getChildren(this.getNode());
    }

    public List<String> getChildrenIds() {
        List<Document> children = this.session.getChildren(this.getNode());
        ArrayList<String> ids = new ArrayList<String>(children.size());
        for (Document child : children) {
            ids.add(child.getUUID());
        }
        return ids;
    }

    public boolean hasChild(String name) {
        return this.session.hasChild(this.getNode(), name);
    }

    public boolean hasChildren() {
        return this.session.hasChildren(this.getNode());
    }

    public Document addChild(String name, String typeName) {
        return this.session.addChild(this.getNode(), name, null, typeName);
    }

    public void orderBefore(String src, String dest) {
        SQLDocument destDoc;
        SQLDocument srcDoc = (SQLDocument)this.getChild(src);
        if (srcDoc == null) {
            throw new DocumentNotFoundException("Document " + this + " has no child: " + src);
        }
        if (dest == null) {
            destDoc = null;
        } else {
            destDoc = (SQLDocument)this.getChild(dest);
            if (destDoc == null) {
                throw new DocumentNotFoundException("Document " + this + " has no child: " + dest);
            }
        }
        this.session.orderBefore(this.getNode(), srcDoc.getNode(), destDoc == null ? null : destDoc.getNode());
    }

    public Set<String> getAllFacets() {
        return this.getNode().getAllMixinTypes();
    }

    public String[] getFacets() {
        return this.getNode().getMixinTypes();
    }

    public boolean hasFacet(String facet) {
        return this.getNode().hasMixinType(facet);
    }

    public boolean addFacet(String facet) {
        return this.session.addMixinType(this.getNode(), facet);
    }

    public boolean removeFacet(String facet) {
        return this.session.removeMixinType(this.getNode(), facet);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getName() + "," + this.getUUID() + ")";
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            return this.equals((SQLDocumentLive)other);
        }
        return false;
    }

    private boolean equals(SQLDocumentLive other) {
        return this.getNode().equals((Object)other.getNode());
    }

    public int hashCode() {
        return this.getNode().hashCode();
    }

    public Document getTargetDocument() {
        return null;
    }

    public void setTargetDocument(Document target) {
        throw new NuxeoException("Not a proxy");
    }

    protected Lock getDocumentLock() {
        throw new UnsupportedOperationException();
    }

    protected Lock setDocumentLock(Lock lock) {
        throw new UnsupportedOperationException();
    }

    protected Lock removeDocumentLock(String owner) {
        throw new UnsupportedOperationException();
    }

    static {
        systemPropNameMap.put("fulltextJobId", "ecm:fulltextJobId");
        systemPropNameMap.put("isTrashed", "ecm:isTrashed");
    }
}

