/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.storage.FulltextDescriptor;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelSetup;
import org.nuxeo.ecm.core.storage.sql.RepositoryBackend;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.VCSClusterInvalidator;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnection;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapper;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapperConnector;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.runtime.datasource.ConnectionHelper;
import org.nuxeo.runtime.datasource.DataSourceHelper;
import org.nuxeo.runtime.datasource.PooledDataSourceRegistry;

public class JDBCBackend
implements RepositoryBackend {
    private static final Log log = LogFactory.getLog(JDBCBackend.class);
    private RepositoryImpl repository;
    private Model model;
    private SQLInfo sqlInfo;
    private VCSClusterInvalidator clusterInvalidator;
    private boolean isPooledDataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model initialize(RepositoryImpl repository) {
        Dialect dialect;
        this.repository = repository;
        RepositoryDescriptor repositoryDescriptor = repository.getRepositoryDescriptor();
        String dataSourceName = JDBCConnection.getDataSourceName(repositoryDescriptor.name);
        try {
            DataSource ds = DataSourceHelper.getDataSource((String)dataSourceName);
            if (ds instanceof PooledDataSourceRegistry.PooledDataSource) {
                this.isPooledDataSource = true;
            }
        }
        catch (NamingException cause) {
            throw new NuxeoException("Cannot acquire datasource: " + dataSourceName, (Throwable)cause);
        }
        try (Connection connection = ConnectionHelper.getConnection((String)dataSourceName);){
            dialect = Dialect.createDialect(connection, repositoryDescriptor);
        }
        catch (SQLException cause) {
            throw new NuxeoException("Cannot get connection from datasource: " + dataSourceName, (Throwable)cause);
        }
        ModelSetup modelSetup = new ModelSetup();
        modelSetup.materializeFulltextSyntheticColumn = dialect.getMaterializeFulltextSyntheticColumn();
        modelSetup.supportsArrayColumns = dialect.supportsArrayColumns();
        switch (dialect.getIdType()) {
            case VARCHAR: 
            case UUID: {
                modelSetup.idType = Model.IdType.STRING;
                break;
            }
            case SEQUENCE: {
                modelSetup.idType = Model.IdType.LONG;
                break;
            }
            default: {
                throw new AssertionError((Object)dialect.getIdType().toString());
            }
        }
        modelSetup.repositoryDescriptor = repositoryDescriptor;
        this.model = new Model(modelSetup);
        this.sqlInfo = new SQLInfo(this.model, dialect, repository.requiresClusterSQL);
        String ddlMode = repositoryDescriptor.getDDLMode();
        if (ddlMode == null) {
            String string = ddlMode = repositoryDescriptor.getNoDDL() ? "ignore" : "execute";
        }
        if (ddlMode.equals("ignore")) {
            log.info((Object)"Skipping database creation");
        } else {
            try (Mapper mapper = this.newMapper(null, false);){
                mapper.createDatabase(ddlMode);
            }
        }
        if (log.isDebugEnabled()) {
            FulltextDescriptor fulltextDescriptor = repositoryDescriptor.getFulltextDescriptor();
            log.debug((Object)String.format("Database ready, fulltext: disabled=%b storedInBlob=%b searchDisabled=%b.", fulltextDescriptor.getFulltextDisabled(), fulltextDescriptor.getFulltextStoredInBlob(), fulltextDescriptor.getFulltextSearchDisabled()));
        }
        return this.model;
    }

    @Override
    public void setClusterInvalidator(VCSClusterInvalidator clusterInvalidator) {
        this.clusterInvalidator = clusterInvalidator;
    }

    @Override
    public Mapper newMapper(Session.PathResolver pathResolver, boolean useInvalidations) {
        boolean noSharing = !useInvalidations;
        VCSClusterInvalidator cnh = useInvalidations ? this.clusterInvalidator : null;
        Mapper mapper = new JDBCMapper(this.model, pathResolver, this.sqlInfo, cnh, this.repository);
        if (this.isPooledDataSource) {
            mapper = JDBCMapperConnector.newConnector(mapper, noSharing);
        } else {
            mapper.connect(false);
        }
        return mapper;
    }

    @Override
    public void shutdown() {
        if (this.clusterInvalidator != null) {
            this.clusterInvalidator.close();
        }
    }
}

