/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.db;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;

public class Update
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Table table;
    protected String newValues;
    protected String[] from;
    protected String where;

    public Update(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public void setNewValues(String newValues) {
        this.newValues = newValues;
    }

    public void setUpdatedColumns(List<Column> columns) {
        this.setUpdatedColumns(columns, Collections.emptySet());
    }

    public void setUpdatedColumns(List<Column> columns, Set<String> deltas) {
        LinkedList<CallSite> updatedColumns = new LinkedList<CallSite>();
        for (Column column : columns) {
            if (column.isIdentity()) continue;
            String col = column.getQuotedName();
            String fvs = column.getFreeVariableSetter();
            String update = deltas.contains(column.getKey()) ? col + " = " + col + " + " + fvs : col + " = " + fvs;
            updatedColumns.add((CallSite)((Object)update));
        }
        this.newValues = StringUtils.join(updatedColumns, (String)", ");
    }

    public void setFrom(String ... from) {
        this.from = from;
    }

    public void setWhere(String where) {
        if (where == null || where.length() == 0) {
            throw new IllegalArgumentException("unexpected empty WHERE");
        }
        this.where = where;
    }

    public String getStatement() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("UPDATE ");
        sb.append(this.table.getQuotedName());
        sb.append(" SET ");
        sb.append(this.newValues);
        if (this.from != null) {
            sb.append(" FROM ");
            if (this.table.getDialect().doesUpdateFromRepeatSelf()) {
                sb.append(this.table.getQuotedName());
                sb.append(", ");
            }
            sb.append(StringUtils.join((Object[])this.from, (String)", "));
        }
        if (this.where == null) {
            throw new IllegalArgumentException("unexpected empty WHERE");
        }
        sb.append(" WHERE ");
        sb.append(this.where);
        return sb.toString();
    }
}

