/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.JDBCUtils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.DataSourceFromUrl;
import org.nuxeo.runtime.datasource.DataSourceHelper;
import org.nuxeo.runtime.datasource.PooledDataSourceRegistry;
import org.tranql.connector.jdbc.ConnectionHandle;

public class ConnectionHelper {
    private static final Log log = LogFactory.getLog(ConnectionHelper.class);

    public static Connection unwrap(Connection connection) throws SQLException {
        if (connection instanceof ConnectionHandle) {
            return (Connection)((ConnectionHandle)connection).getAssociation().getPhysicalConnection();
        }
        try {
            Method m = connection.getClass().getMethod("getInnermostDelegate", new Class[0]);
            m.setAccessible(true);
            Connection delegate = (Connection)m.invoke((Object)connection, new Object[0]);
            if (delegate == null) {
                log.error((Object)"Cannot access underlying connection, you must use accessToUnderlyingConnectionAllowed=true in the pool configuration");
            } else {
                connection = delegate;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return connection;
    }

    public static Connection getConnection(String dataSourceName) throws SQLException {
        return ConnectionHelper.getConnection(dataSourceName, false);
    }

    public static Connection getConnection(String dataSourceName, boolean noSharing) throws SQLException {
        DataSource dataSource = ConnectionHelper.getDataSource(dataSourceName);
        if (dataSource instanceof PooledDataSourceRegistry.PooledDataSource) {
            return ((PooledDataSourceRegistry.PooledDataSource)dataSource).getConnection(noSharing);
        }
        return JDBCUtils.getConnection((DataSource)dataSource);
    }

    private static DataSource getDataSource(String dataSourceName) throws SQLException {
        try {
            return DataSourceHelper.getDataSource(dataSourceName);
        }
        catch (NamingException e) {
            if (Framework.isTestModeSet()) {
                String url = Framework.getProperty((String)"nuxeo.test.vcs.url");
                String user = Framework.getProperty((String)"nuxeo.test.vcs.user");
                String password = Framework.getProperty((String)"nuxeo.test.vcs.password");
                if (url != null && user != null) {
                    return new DataSourceFromUrl(url, user, password);
                }
            }
            throw new SQLException("Cannot find datasource: " + dataSourceName, e);
        }
    }
}

