/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.listener;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.video.VideoHelper;
import org.nuxeo.ecm.platform.video.service.VideoInfoWork;
import org.nuxeo.runtime.api.Framework;

public class VideoChangedListener
implements EventListener {
    private static final Logger log = LogManager.getLogger(VideoChangedListener.class);
    public static final String DISABLE_VIDEO_CONVERSIONS_GENERATION_LISTENER = "disableVideoConversionsGenerationListener";

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (Boolean.TRUE.equals(ctx.getProperty(DISABLE_VIDEO_CONVERSIONS_GENERATION_LISTENER))) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.trace("Video conversions are disabled for document {}", supplierArray);
            return;
        }
        String eventName = event.getName();
        if (this.shouldProcess(doc, eventName)) {
            if ("beforeDocumentModification".equals(eventName)) {
                try {
                    this.resetProperties(doc);
                }
                catch (IOException e) {
                    throw new NuxeoException(String.format("Error while resetting video properties of document %s.", doc), (Throwable)e);
                }
            }
            this.scheduleAsyncProcessing(doc);
        }
    }

    protected boolean shouldProcess(DocumentModel doc, String eventName) {
        return doc.hasFacet("Video") && !doc.isProxy() && (Boolean.TRUE.equals(doc.getContextData("forceInformationsGeneration")) || "documentCreated".equals(eventName) || doc.getProperty("file:content").isDirty());
    }

    protected void resetProperties(DocumentModel doc) throws IOException {
        log.debug("Resetting video info, storyboard, previews and conversions of document {}", (Object)doc);
        VideoHelper.updateVideoInfo(doc, null);
        VideoHelper.updateStoryboard(doc, null);
        VideoHelper.updatePreviews(doc, null);
        doc.setPropertyValue("vid:transcodedVideos", null);
    }

    protected void scheduleAsyncProcessing(DocumentModel doc) {
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        VideoInfoWork work = new VideoInfoWork(doc.getRepositoryName(), doc.getId());
        log.debug("Scheduling work: video info of document {}.", (Object)doc);
        workManager.schedule((Work)work, true);
    }
}

