/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.plugins;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;

public class BasicAuthenticator
implements NuxeoAuthenticationPlugin {
    protected static final String REALM_NAME_KEY = "RealmName";
    protected static final String FORCE_PROMPT_KEY = "ForcePromptURL";
    protected static final String AUTO_PROMPT_KEY = "AutoPrompt";
    protected static final String PROMPT_URL_KEY = "PromptUrl";
    protected static final String DEFAULT_REALMNAME = "Nuxeo 5";
    protected static final String BA_HEADER_NAME = "WWW-Authenticate";
    protected static final String EXCLUDE_URL_KEY = "ExcludeBAHeader";
    protected String realName;
    protected Boolean autoPrompt = false;
    protected List<String> forcePromptURLs;
    private List<String> excludedHeadersForBasicAuth;

    @Override
    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        try {
            Integer requestStatusCode;
            if (this.needToAddBAHeader(httpRequest)) {
                String baHeader = "Basic realm=\"" + this.realName + "\"";
                httpResponse.addHeader(BA_HEADER_NAME, baHeader);
            }
            int statusCode = (requestStatusCode = (Integer)httpRequest.getAttribute("org.nuxeo.ecm.login.status.code")) != null ? requestStatusCode : 401;
            httpResponse.sendError(statusCode);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean needToAddBAHeader(HttpServletRequest httpRequest) {
        for (String header : this.excludedHeadersForBasicAuth) {
            if (StringUtils.isNotBlank((CharSequence)httpRequest.getHeader(header))) {
                return false;
            }
            if (httpRequest.getCookies() == null) continue;
            for (Cookie cookie : httpRequest.getCookies()) {
                if (!cookie.getName().equals(header)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String auth = httpRequest.getHeader("authorization");
        if (auth != null && auth.toLowerCase().startsWith("basic")) {
            int idx = auth.indexOf(32);
            String b64userPassword = auth.substring(idx + 1);
            byte[] clearUp = Base64.decodeBase64((String)b64userPassword);
            String userCredentials = new String(clearUp);
            int idxOfColon = userCredentials.indexOf(58);
            if (idxOfColon > 0 && idxOfColon < userCredentials.length() - 1) {
                String username = userCredentials.substring(0, idxOfColon);
                String password = userCredentials.substring(idxOfColon + 1);
                return new UserIdentificationInfo(username, password);
            }
            return null;
        }
        return null;
    }

    @Override
    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        if (this.autoPrompt.booleanValue()) {
            return true;
        }
        String requestedURI = httpRequest.getRequestURI();
        String context = httpRequest.getContextPath() + "/";
        requestedURI = requestedURI.substring(context.length());
        for (String prefixURL : this.forcePromptURLs) {
            if (!requestedURI.startsWith(prefixURL)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initPlugin(Map<String, String> parameters) {
        this.realName = parameters.containsKey(REALM_NAME_KEY) ? parameters.get(REALM_NAME_KEY) : DEFAULT_REALMNAME;
        if (parameters.containsKey(AUTO_PROMPT_KEY)) {
            this.autoPrompt = parameters.get(AUTO_PROMPT_KEY).equalsIgnoreCase("true");
        }
        this.forcePromptURLs = new ArrayList<String>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (!entry.getKey().startsWith(FORCE_PROMPT_KEY)) continue;
            this.forcePromptURLs.add(entry.getValue());
        }
        this.excludedHeadersForBasicAuth = new ArrayList<String>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (!entry.getKey().startsWith(EXCLUDE_URL_KEY)) continue;
            this.excludedHeadersForBasicAuth.add(entry.getValue());
        }
    }

    @Override
    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }
}

