/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.external;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService;
import org.nuxeo.runtime.api.Framework;

public class ExternalRequestFilter
implements Filter {
    private static final Log log = LogFactory.getLog(ExternalRequestFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession httpSession;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (request != null && httpRequest.getParameter("requestedUrl") != null && (httpSession = httpRequest.getSession(false)) != null && httpSession.getAttribute("org.nuxeo.ecm.login.identity") != null) {
            log.debug((Object)"Detect redirection while an active session is running");
            String requestedUrl = httpRequest.getParameter("requestedUrl");
            if (requestedUrl != null && !"".equals(requestedUrl)) {
                try {
                    requestedUrl = URLDecoder.decode(requestedUrl, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)("Unable to get the requestedUrl parameter" + e));
                }
            }
            if (requestedUrl != null) {
                PluggableAuthenticationService service = (PluggableAuthenticationService)((Object)Framework.getService(PluggableAuthenticationService.class));
                String baseURL = service.getBaseURL(request);
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.sendRedirect(baseURL + requestedUrl);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

