/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Filter;

public class LifeCycleFilter
implements Filter {
    private static final long serialVersionUID = -6222667096842773182L;
    private final List<String> accepted;
    private final List<String> excluded;

    public LifeCycleFilter(List<String> accepted, List<String> excluded) {
        this.accepted = accepted;
        this.excluded = excluded;
    }

    public LifeCycleFilter(String lifeCycle, boolean isRequired) {
        if (isRequired) {
            this.accepted = new ArrayList<String>();
            this.excluded = null;
            this.accepted.add(lifeCycle);
        } else {
            this.excluded = new ArrayList<String>();
            this.accepted = null;
            this.excluded.add(lifeCycle);
        }
    }

    @Override
    public boolean accept(DocumentModel docModel) {
        String lifeCycleState = docModel.getCurrentLifeCycleState();
        if (this.excluded != null && this.excluded.contains(lifeCycleState)) {
            return false;
        }
        return this.accepted == null || this.accepted.contains(lifeCycleState);
    }
}

