/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.propertiesmapping.impl;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.propertiesmapping.PropertiesMappingContributionRegistry;
import org.nuxeo.ecm.core.api.propertiesmapping.PropertiesMappingDescriptor;
import org.nuxeo.ecm.core.api.propertiesmapping.PropertiesMappingService;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class PropertiesMappingComponent
extends DefaultComponent
implements PropertiesMappingService {
    public static final Log log = LogFactory.getLog(PropertiesMappingComponent.class);
    public static final String MAPPING_EP = "mapping";
    protected PropertiesMappingContributionRegistry mappingsRegistry = new PropertiesMappingContributionRegistry();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (MAPPING_EP.equals(extensionPoint)) {
            PropertiesMappingDescriptor desc = (PropertiesMappingDescriptor)contribution;
            this.mappingsRegistry.addContribution(desc);
        }
    }

    @Override
    public Map<String, String> getMapping(String mappingName) {
        return this.mappingsRegistry.getMappingProperties(mappingName);
    }

    @Override
    public void mapProperties(CoreSession session, DocumentModel sourceDoc, DocumentModel targetDoc, String mapping) {
        Map<String, String> properties = this.getMapping(mapping);
        for (String keyProp : properties.keySet()) {
            Property sourceProperty = sourceDoc.getProperty(keyProp);
            Property targetProperty = targetDoc.getProperty(properties.get(keyProp));
            Type sourceType = sourceProperty.getType();
            Type targetType = targetProperty.getType();
            if (!this.compatibleTypes(targetType, sourceType)) {
                throw new NuxeoException(String.format("Invalid mapping. Cannot map %s on type %s ", sourceType, targetType));
            }
            targetDoc.setPropertyValue(targetProperty.getXPath(), sourceProperty.getValue());
        }
        session.saveDocument(targetDoc);
    }

    protected boolean compatibleTypes(Type targetType, Type sourceType) {
        if (!sourceType.getName().equals(targetType.getName())) {
            return false;
        }
        if (sourceType.isComplexType()) {
            for (Field field : ((ComplexType)sourceType).getFields()) {
                Field targetField = ((ComplexType)targetType).getField(field.getName());
                if (targetField != null && field.getType().equals(targetField.getType())) continue;
                return false;
            }
        }
        if (sourceType.isListType()) {
            if (!((ListType)sourceType).getFieldType().equals(((ListType)targetType).getFieldType())) {
                return false;
            }
            if (((ListType)sourceType).getFieldType().isComplexType()) {
                return this.compatibleTypes(((ListType)targetType).getFieldType(), ((ListType)sourceType).getFieldType());
            }
        }
        return true;
    }
}

