/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.nuxeo.common.file.FileCache;
import org.nuxeo.common.file.LRUFileCache;
import org.nuxeo.ecm.core.blob.AbstractBlobStore;
import org.nuxeo.ecm.core.blob.BlobStore;
import org.nuxeo.ecm.core.blob.BlobUpdateContext;
import org.nuxeo.ecm.core.blob.BlobWriteContext;
import org.nuxeo.ecm.core.blob.CachingConfiguration;
import org.nuxeo.ecm.core.blob.LocalBlobStore;
import org.nuxeo.ecm.core.blob.PathStrategyFlat;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerStatus;
import org.nuxeo.runtime.trackers.files.FileEventTracker;

public class CachingBlobStore
extends AbstractBlobStore {
    protected final BlobStore store;
    public final Path cacheDir;
    protected final FileCache fileCache;
    protected final PathStrategyFlat tmpPathStrategy;
    protected final BlobStore tmpStore;
    protected final BinaryGarbageCollector gc;

    public CachingBlobStore(String name, BlobStore store, CachingConfiguration config) {
        super(name, store.getKeyStrategy());
        this.store = store;
        this.cacheDir = config.dir;
        this.fileCache = new LRUFileCache(this.cacheDir.toFile(), config.maxSize, config.maxCount, config.minAge);
        FileEventTracker.registerProtectedPath((String)this.cacheDir.toAbsolutePath().toString());
        this.tmpPathStrategy = new PathStrategyFlat(this.cacheDir);
        this.tmpStore = new LocalBlobStore(name, store.getKeyStrategy(), this.tmpPathStrategy);
        this.gc = new CachingBinaryGarbageCollector(store.getBinaryGarbageCollector());
    }

    @Override
    public boolean hasVersioning() {
        return this.store.hasVersioning();
    }

    @Override
    public BlobStore unwrap() {
        return this.store.unwrap();
    }

    @Override
    public String writeBlob(BlobWriteContext blobWriteContext) throws IOException {
        String tmpKey = this.tmpStore.writeBlob(blobWriteContext.copyWithKey(this.randomString()));
        String key = blobWriteContext.getKey();
        if (blobWriteContext.useDeDuplication()) {
            if (this.fileCache.getFile(key) != null) {
                this.logTrace("<--", "exists");
                this.logTrace("hnote right: " + key);
                this.tmpStore.deleteBlob(tmpKey);
                return key;
            }
            this.logTrace("<--", "missing");
            this.logTrace("hnote right: " + key);
        }
        Path tmp = this.tmpPathStrategy.getPathForKey(tmpKey);
        blobWriteContext.setFile(tmp);
        String returnedKey = this.store.writeBlob(blobWriteContext.copyWithNoWriteObserverAndKey(key));
        this.logTrace(this.name, "-->", this.name, "rename");
        this.logTrace("hnote right of " + this.name + ": " + returnedKey);
        this.fileCache.putFile(returnedKey, tmp.toFile());
        return returnedKey;
    }

    @Override
    public boolean copyBlob(String key, BlobStore sourceStore, String sourceKey, boolean atomicMove) throws IOException {
        boolean found;
        CachingBlobStore cachingSourceStore;
        CachingBlobStore cachingBlobStore = cachingSourceStore = sourceStore instanceof CachingBlobStore ? (CachingBlobStore)sourceStore : null;
        if ((!atomicMove || this.copyBlobIsOptimized(sourceStore)) && cachingSourceStore != null) {
            this.tmpStore.copyBlob(key, cachingSourceStore.tmpStore, sourceKey, atomicMove);
        }
        if ((found = this.store.copyBlob(key, sourceStore, sourceKey, atomicMove)) && atomicMove && cachingSourceStore != null) {
            cachingSourceStore.tmpStore.deleteBlob(sourceKey);
        }
        return found;
    }

    @Override
    public BlobStore.OptionalOrUnknown<Path> getFile(String key) {
        File cachedFile = this.fileCache.getFile(key);
        if (cachedFile == null) {
            this.logTrace("<--", "missing");
            this.logTrace("hnote right: " + key);
            return BlobStore.OptionalOrUnknown.missing();
        }
        this.logTrace("<-", "read " + cachedFile.length() + " bytes");
        this.logTrace("hnote right: " + key);
        return BlobStore.OptionalOrUnknown.of(cachedFile.toPath());
    }

    @Override
    public BlobStore.OptionalOrUnknown<InputStream> getStream(String key) throws IOException {
        File cachedFile = this.fileCache.getFile(key);
        if (cachedFile == null) {
            this.logTrace("<--", "missing");
            this.logTrace("hnote right: " + key);
            String tmpKey = this.randomString();
            boolean found = this.tmpStore.copyBlob(tmpKey, this.store, key, false);
            if (!found) {
                return BlobStore.OptionalOrUnknown.missing();
            }
            File tmp = this.tmpPathStrategy.getPathForKey(tmpKey).toFile();
            this.logTrace("->", "write " + tmp.length() + " bytes");
            this.logTrace("hnote right: " + key);
            cachedFile = this.fileCache.putFile(key, tmp);
        } else {
            this.logTrace("<-", "read " + cachedFile.length() + " bytes");
            this.logTrace("hnote right: " + key);
        }
        return BlobStore.OptionalOrUnknown.of(new FileInputStream(cachedFile));
    }

    @Override
    public boolean readBlob(String key, Path dest) throws IOException {
        BlobStore.OptionalOrUnknown<InputStream> streamOpt = this.getStream(key);
        if (!streamOpt.isPresent()) {
            return false;
        }
        try (InputStream stream = streamOpt.get();){
            Files.copy(stream, dest, StandardCopyOption.REPLACE_EXISTING);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void writeBlobProperties(BlobUpdateContext blobUpdateContext) throws IOException {
        this.store.writeBlobProperties(blobUpdateContext);
    }

    @Override
    public void deleteBlob(String key) {
        this.tmpStore.deleteBlob(key);
        this.store.deleteBlob(key);
    }

    @Override
    public BinaryGarbageCollector getBinaryGarbageCollector() {
        return this.gc;
    }

    public class CachingBinaryGarbageCollector
    implements BinaryGarbageCollector {
        protected final BinaryGarbageCollector delegate;

        public CachingBinaryGarbageCollector(BinaryGarbageCollector delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getId() {
            return this.delegate.getId();
        }

        @Override
        public void start() {
            this.delegate.start();
        }

        @Override
        public void mark(String key) {
            this.delegate.mark(key);
        }

        @Override
        public void stop(boolean delete) {
            this.delegate.stop(delete);
            if (delete) {
                CachingBlobStore.this.logTrace("->", "clear");
                CachingBlobStore.this.fileCache.clear();
            }
        }

        @Override
        public BinaryManagerStatus getStatus() {
            return this.delegate.getStatus();
        }

        @Override
        public boolean isInProgress() {
            return this.delegate.isInProgress();
        }
    }
}

