/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.blob.AbstractBlobGarbageCollector;
import org.nuxeo.ecm.core.blob.AbstractBlobStore;
import org.nuxeo.ecm.core.blob.BlobStore;
import org.nuxeo.ecm.core.blob.BlobWriteContext;
import org.nuxeo.ecm.core.blob.ByteRange;
import org.nuxeo.ecm.core.blob.KeyStrategy;
import org.nuxeo.ecm.core.blob.PropertyBasedConfiguration;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.runtime.api.Framework;

public class InMemoryBlobStore
extends AbstractBlobStore {
    private static final Logger log = LogManager.getLogger(InMemoryBlobStore.class);
    protected Map<String, byte[]> map = new ConcurrentHashMap<String, byte[]>();
    protected final InMemoryBlobGarbageCollector gc = new InMemoryBlobGarbageCollector();
    protected final boolean emulateNoStream;
    protected final boolean emulateLocalFile;
    protected final boolean allowByteRange;

    public InMemoryBlobStore(String name, KeyStrategy keyStrategy) {
        this(name, null, keyStrategy, false, false);
    }

    public InMemoryBlobStore(String name, PropertyBasedConfiguration config, KeyStrategy keyStrategy) {
        this(name, config, keyStrategy, false, false);
    }

    protected InMemoryBlobStore(String name, KeyStrategy keyStrategy, boolean emulateNoStream, boolean emulateLocalFile) {
        this(name, null, keyStrategy, emulateNoStream, emulateLocalFile);
    }

    protected InMemoryBlobStore(String name, PropertyBasedConfiguration config, KeyStrategy keyStrategy, boolean emulateNoStream, boolean emulateLocalFile) {
        super(name, keyStrategy);
        this.emulateNoStream = emulateNoStream;
        this.emulateLocalFile = emulateLocalFile;
        this.allowByteRange = config != null && config.getBooleanProperty("allowByteRange");
    }

    @Override
    public String writeBlob(BlobWriteContext blobWriteContext) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.transfer(blobWriteContext, baos);
        String key = blobWriteContext.getKey();
        this.map.put(key, baos.toByteArray());
        return key;
    }

    @Override
    public boolean copyBlobIsOptimized(BlobStore sourceStore) {
        return sourceStore instanceof InMemoryBlobStore;
    }

    @Override
    public boolean copyBlob(String key, BlobStore sourceStore, String sourceKey, boolean atomicMove) throws IOException {
        boolean found = this.copyBlob(key, sourceStore, sourceKey);
        if (found && atomicMove) {
            sourceStore.deleteBlob(sourceKey);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean copyBlob(String key, BlobStore sourceStore, String sourceKey) throws IOException {
        BlobStore.OptionalOrUnknown<InputStream> streamOpt = sourceStore.getStream(sourceKey);
        if (streamOpt.isKnown()) {
            byte[] bytes;
            if (!streamOpt.isPresent()) {
                return false;
            }
            try (InputStream stream = streamOpt.get();){
                bytes = IOUtils.toByteArray((InputStream)stream);
            }
            this.map.put(key, bytes);
            return true;
        }
        BlobStore.OptionalOrUnknown<Path> fileOpt = sourceStore.getFile(sourceKey);
        if (fileOpt.isKnown()) {
            if (!fileOpt.isPresent()) {
                return false;
            }
            byte[] bytes = Files.readAllBytes(fileOpt.get());
            this.map.put(key, bytes);
            return true;
        }
        Path tmp = Files.createTempFile("bin_", ".tmp", new FileAttribute[0]);
        try {
            boolean found = sourceStore.readBlob(sourceKey, tmp);
            if (!found) {
                boolean bl = false;
                return bl;
            }
            byte[] bytes = Files.readAllBytes(tmp);
            this.map.put(key, bytes);
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                Files.delete(tmp);
            }
            catch (IOException e) {
                log.warn((Object)e, (Throwable)e);
            }
        }
    }

    protected ByteArrayInputStream getStreamInternal(String key) {
        ByteRange byteRange;
        if (this.allowByteRange) {
            MutableObject keyHolder = new MutableObject((Object)key);
            byteRange = InMemoryBlobStore.getByteRangeFromKey((MutableObject<String>)keyHolder);
            key = (String)keyHolder.getValue();
        } else {
            byteRange = null;
        }
        byte[] bytes = this.map.get(key);
        if (bytes == null) {
            return null;
        }
        if (byteRange == null) {
            return new ByteArrayInputStream(bytes);
        }
        return new ByteArrayInputStream(bytes, (int)byteRange.getStart(), (int)byteRange.getLength());
    }

    @Override
    public BlobStore.OptionalOrUnknown<Path> getFile(String key) {
        if (!this.emulateLocalFile) {
            return BlobStore.OptionalOrUnknown.unknown();
        }
        ByteArrayInputStream stream = this.getStreamInternal(key);
        if (stream == null) {
            return BlobStore.OptionalOrUnknown.missing();
        }
        try {
            Path tmp = Files.createTempFile("tmp_", ".tmp", new FileAttribute[0]);
            Framework.trackFile((File)tmp.toFile(), (Object)tmp);
            FileUtils.copyToFile((InputStream)stream, (File)tmp.toFile());
            return BlobStore.OptionalOrUnknown.of(tmp);
        }
        catch (IOException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public BlobStore.OptionalOrUnknown<InputStream> getStream(String key) throws IOException {
        if (this.emulateNoStream) {
            return BlobStore.OptionalOrUnknown.unknown();
        }
        ByteArrayInputStream stream = this.getStreamInternal(key);
        if (stream == null) {
            return BlobStore.OptionalOrUnknown.missing();
        }
        return BlobStore.OptionalOrUnknown.of(stream);
    }

    @Override
    public boolean readBlob(String key, Path dest) throws IOException {
        ByteArrayInputStream stream = this.getStreamInternal(key);
        if (stream == null) {
            return false;
        }
        Files.copy(stream, dest, StandardCopyOption.REPLACE_EXISTING);
        return true;
    }

    @Override
    public void deleteBlob(String key) {
        this.map.remove(key);
    }

    @Override
    public BinaryGarbageCollector getBinaryGarbageCollector() {
        return this.gc;
    }

    public class InMemoryBlobGarbageCollector
    extends AbstractBlobGarbageCollector {
        @Override
        public String getId() {
            return this.toString();
        }

        @Override
        public void removeUnmarkedBlobsAndUpdateStatus(boolean delete) {
            Iterator<Map.Entry<String, byte[]>> it = InMemoryBlobStore.this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, byte[]> es = it.next();
                String key = es.getKey();
                byte[] bytes = es.getValue();
                if (this.marked.contains(key)) {
                    this.status.sizeBinaries += (long)bytes.length;
                    ++this.status.numBinaries;
                    continue;
                }
                this.status.sizeBinariesGC += (long)bytes.length;
                ++this.status.numBinariesGC;
                if (!delete) continue;
                it.remove();
            }
        }
    }
}

