/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.runtime.api.Framework;

public class BlobUtils {
    public static final String ZIP_ENTRY_ENCODING_PROPERTY = "zip.entry.encoding";

    protected static String escapeEntryPath(String path) {
        String zipEntryEncoding = Framework.getProperty((String)ZIP_ENTRY_ENCODING_PROPERTY);
        if (zipEntryEncoding != null && zipEntryEncoding.equals(ZIP_ENTRY_ENCODING_OPTIONS.ascii.toString())) {
            return StringUtils.toAscii((String)path, (boolean)true);
        }
        return path;
    }

    protected static String getFileName(Blob blob) {
        Object entry = blob.getFilename();
        if (entry == null) {
            entry = "Unknown_" + System.identityHashCode(blob);
        }
        return BlobUtils.escapeEntryPath((String)entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Blob zip(Blob blob, String filename) throws IOException {
        if (filename == null || (filename = filename.trim()).length() == 0) {
            filename = blob.getFilename();
        }
        File file = Framework.createTempFile((String)"nxops-createzip-", (String)".tmp");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));
        Framework.trackFile((File)file, (Object)file);
        try {
            BlobUtils.zip(blob, out);
        }
        finally {
            out.finish();
            out.close();
        }
        return Blobs.createBlob(file, "application/zip", null, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void zip(Blob blob, ZipOutputStream out) throws IOException {
        String entry = BlobUtils.getFileName(blob);
        try (InputStream in = blob.getStream();){
            ZipUtils._zip((String)entry, (InputStream)in, (ZipOutputStream)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Blob zip(List<Blob> blobs, String fileName) throws IOException {
        if (fileName == null || (fileName = fileName.trim()).length() == 0) {
            fileName = blobs.isEmpty() ? null : blobs.get(0).getFilename();
        }
        File file = Framework.createTempFile((String)"nxops-createzip-", (String)".tmp");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));
        Framework.trackFile((File)file, (Object)file);
        try {
            BlobUtils.zip(blobs, out);
        }
        finally {
            out.finish();
            out.close();
        }
        return Blobs.createBlob(file, "application/zip", null, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void zip(List<Blob> blobs, ZipOutputStream out) throws IOException {
        HashSet<String> names = new HashSet<String>();
        int cnt = 1;
        for (Blob blob : blobs) {
            Object entry = BlobUtils.getFileName(blob);
            if (!names.add((String)entry)) {
                entry = "renamed_" + cnt++ + "_" + (String)entry;
            }
            try (InputStream in = blob.getStream();){
                ZipUtils._zip((String)entry, (InputStream)in, (ZipOutputStream)out);
            }
        }
    }

    public static enum ZIP_ENTRY_ENCODING_OPTIONS {
        ascii;

    }
}

