/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.client;

import java.util.Iterator;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoObject;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoPropertyDataBase;

public class NuxeoProperty<T>
implements Property<T> {
    private final NuxeoPropertyDataBase<T> prop;

    public NuxeoProperty(NuxeoObject object, String id) {
        this.prop = object.data.getProperty(id);
    }

    public PropertyDefinition<T> getDefinition() {
        return this.prop.getPropertyDefinition();
    }

    public String getDisplayName() {
        return this.prop.getDisplayName();
    }

    public String getId() {
        return this.prop.getId();
    }

    public String getLocalName() {
        return this.prop.getLocalName();
    }

    public String getQueryName() {
        return this.prop.getQueryName();
    }

    public PropertyType getType() {
        return this.prop.getPropertyDefinition().getPropertyType();
    }

    public <U> U getValue() {
        return this.prop.getValue();
    }

    public T getFirstValue() {
        return this.prop.getFirstValue();
    }

    public String getValueAsString() {
        return String.valueOf(this.getFirstValue());
    }

    public String getValuesAsString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        Iterator<T> it = this.getValues().iterator();
        while (it.hasNext()) {
            buf.append(String.valueOf(it.next()));
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public List<T> getValues() {
        return this.prop.getValues();
    }

    public boolean isMultiValued() {
        return this.prop.getPropertyDefinition().getCardinality() == Cardinality.MULTI;
    }

    public List<CmisExtensionElement> getExtensions() {
        throw new UnsupportedOperationException();
    }

    public void setExtensions(List<CmisExtensionElement> extensions) {
        throw new UnsupportedOperationException();
    }
}

