/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.runtime.api.Framework;

public class DirectoryCSVLoader {
    private static final Logger log = LogManager.getLogger(DirectoryCSVLoader.class);
    public static final String CSV_NULL_MARKER = "__NULL__";

    private DirectoryCSVLoader() {
    }

    public static void loadData(String dataFileName, char delimiter, Schema schema, Consumer<Map<String, Object>> loader) {
        Blob blob = DirectoryCSVLoader.createBlob(dataFileName);
        DirectoryCSVLoader.loadData(blob, delimiter, schema, loader);
    }

    protected static Blob createBlob(String dataFileName) {
        Blob blob;
        block8: {
            InputStream in = DirectoryCSVLoader.getResource(dataFileName);
            try {
                blob = Blobs.createBlob((InputStream)in, (String)"text/csv");
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DirectoryException("Read error while creating blob from data file: " + dataFileName, (Throwable)e);
                }
            }
            in.close();
        }
        return blob;
    }

    public static void loadData(Blob dataBlob, char delimiter, Schema schema, Consumer<Map<String, Object>> loader) {
        BiConsumer<Map<String, Object>, Integer> loaderWithLineno = DirectoryCSVLoader.toLoaderEnrichedOnError(loader);
        String dataFileName = dataBlob.getFilename();
        try (InputStream in = dataBlob.getStream();
             CSVParser csvParser = new CSVParser((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), CSVFormat.DEFAULT.withDelimiter(delimiter).withHeader(new String[0]));){
            Map header = csvParser.getHeaderMap();
            ArrayList<Field> fields = new ArrayList<Field>();
            for (String columnName : header.keySet()) {
                Field field = schema.getField(columnName.trim());
                if (field == null) {
                    throw new DirectoryException("Column not found: " + columnName + " in schema: " + schema.getName());
                }
                fields.add(field);
            }
            int lineno = 1;
            for (CSVRecord record : csvParser) {
                ++lineno;
                if (record.size() == 0 || record.size() == 1 && StringUtils.isBlank((CharSequence)record.get(0))) continue;
                if (!record.isConsistent()) {
                    log.error("Invalid column count while reading CSV file: {}, line: {}", (Object)dataFileName, (Object)lineno);
                    continue;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 0; i < header.size(); ++i) {
                    Field field = (Field)fields.get(i);
                    String value = record.get(i);
                    Object v = CSV_NULL_MARKER.equals(value) ? null : DirectoryCSVLoader.decode(field, value);
                    map.put(field.getName().getPrefixedName(), v);
                }
                loaderWithLineno.accept(map, lineno);
            }
        }
        catch (IOException e) {
            throw new DirectoryException("Read error while reading data file: " + dataFileName, (Throwable)e);
        }
    }

    protected static BiConsumer<Map<String, Object>, Integer> toLoaderEnrichedOnError(Consumer<Map<String, Object>> loader) {
        return (map, lineno) -> {
            try {
                loader.accept((Map<String, Object>)map);
            }
            catch (DirectoryException e) {
                e.addInfo("At line: " + lineno);
                throw e;
            }
        };
    }

    protected static Object decode(Field field, String value) {
        Type type = field.getType();
        if (type instanceof DateType) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(Timestamp.valueOf(value));
            return cal;
        }
        return type.decode(value);
    }

    protected static InputStream getResource(String name) {
        InputStream in = DirectoryCSVLoader.class.getClassLoader().getResourceAsStream(name);
        if (in == null && (in = Framework.getResourceLoader().getResourceAsStream(name)) == null) {
            throw new DirectoryException("Data file not found: " + name);
        }
        return in;
    }
}

