/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFieldMapper;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.core.CoreDirectoryDescriptor;
import org.nuxeo.ecm.directory.core.CoreDirectorySession;
import org.nuxeo.runtime.api.Framework;

public class CoreDirectory
extends AbstractDirectory {
    private static final Log log = LogFactory.getLog(CoreDirectory.class);
    protected final Schema schema;

    public CoreDirectory(CoreDirectoryDescriptor descriptor) {
        super(descriptor, null);
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        this.schema = schemaManager.getSchema(descriptor.schemaName);
        this.fieldMapper = new DirectoryFieldMapper(descriptor.fieldMapping);
        if (this.schema == null) {
            throw new DirectoryException(String.format("Unknown schema '%s' for directory '%s' ", descriptor.schemaName, this.getName()));
        }
        this.start();
    }

    public CoreDirectoryDescriptor getDescriptor() {
        return (CoreDirectoryDescriptor)this.descriptor;
    }

    public void start() {
        final CoreDirectoryDescriptor descriptor = this.getDescriptor();
        UnrestrictedSessionRunner directoryInitializer = new UnrestrictedSessionRunner(descriptor.getRepositoryName()){

            public void run() {
                String createPath = descriptor.getCreatePath();
                DocumentModel rootFolder = null;
                PathRef rootRef = new PathRef(createPath);
                if (this.session.exists((DocumentRef)rootRef)) {
                    rootFolder = this.session.getDocument((DocumentRef)rootRef);
                }
                if (rootFolder == null) {
                    String parentFolder = createPath.substring(0, createPath.lastIndexOf("/"));
                    if (createPath.lastIndexOf("/") == 0) {
                        parentFolder = "/";
                    }
                    String createFolder = createPath.substring(createPath.lastIndexOf("/") + 1, createPath.length());
                    log.info((Object)String.format("Root folder '%s' has not been found for the directory '%s' on the repository '%s', will create it with given ACL", createPath, CoreDirectory.this.getName(), descriptor.getRepositoryName()));
                    if (descriptor.canCreateRootFolder()) {
                        try {
                            DocumentModel doc = this.session.createDocumentModel(parentFolder, createFolder, "Folder");
                            doc.setProperty("dublincore", "title", (Object)createFolder);
                            this.session.createDocument(doc);
                            for (int i = 0; i < descriptor.acls.length; ++i) {
                                String userOrGroupName = descriptor.acls[i].userOrGroupName;
                                String privilege = descriptor.acls[i].privilege;
                                boolean granted = descriptor.acls[i].granted;
                                CoreDirectory.this.setACL(doc, userOrGroupName, privilege, granted);
                            }
                            this.session.save();
                        }
                        catch (DocumentNotFoundException e) {
                            throw new DirectoryException(String.format("The root folder '%s' can not be created under '%s' for the directory '%s' on the repository '%s', please make sure you have set the right path or that the path exist", createFolder, parentFolder, CoreDirectory.this.getName(), descriptor.getRepositoryName()), (Throwable)e);
                        }
                    }
                } else {
                    log.info((Object)String.format("Root folder '%s' has been found for the directory '%s' on the repository '%s', ACL will not be set", createPath, CoreDirectory.this.getName(), descriptor.getRepositoryName()));
                }
            }
        };
        directoryInitializer.runUnrestricted();
    }

    protected DocumentModel setACL(DocumentModel rootFolder, String userOrGroupName, String privilege, boolean granted) {
        ACP acp = rootFolder.getACP();
        ACL localACL = acp.getOrCreateACL();
        localACL.add(new ACE(userOrGroupName, privilege, granted));
        rootFolder.setACP(acp, true);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Set ACL on root folder '%s' : userOrGroupName = '%s', privilege = '%s' , granted = '%s' ", rootFolder.getPathAsString(), userOrGroupName, privilege, granted));
        }
        return rootFolder.getCoreSession().saveDocument(rootFolder);
    }

    public Field getField(String name) {
        Field field = this.schema.getField(name);
        if (field == null) {
            throw new DirectoryException(String.format("Field '%s' does not exist in the schema '%s'", name, this.schema.getName()));
        }
        return field;
    }

    public Session getSession() {
        CoreDirectorySession session = new CoreDirectorySession(this);
        this.addSession((Session)session);
        return session;
    }
}

