/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.memory;

import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.storage.ExpressionEvaluator;

public class MapExpressionEvaluator
extends ExpressionEvaluator {
    protected static final Long ZERO = 0L;
    protected static final Long ONE = 1L;
    protected Map<String, Object> map;

    public MapExpressionEvaluator() {
        super(null, null, true);
    }

    public boolean matchesEntry(Expression expression, Map<String, Object> map) {
        this.map = map;
        Object result = this.walkExpression(expression);
        return Boolean.TRUE.equals(result);
    }

    protected QueryParseException unknownProperty(String name) {
        return new QueryParseException("No column: " + name);
    }

    public Boolean walkMixinTypes(List<String> mixins, boolean include) {
        throw this.unknownProperty("ecm:mixinType");
    }

    protected Boolean walkEcmFulltext(String name, Operator op, Operand rvalue) {
        throw this.unknownProperty("ecm:fulltext");
    }

    protected Boolean walkEcmPath(Operator op, Operand rvalue) {
        throw this.unknownProperty("ecm:path");
    }

    public Boolean walkStartsWith(Operand lvalue, Operand rvalue) {
        throw new QueryParseException("Cannot use operator: " + Operator.STARTSWITH);
    }

    protected Boolean walkAncestorId(Operator op, Operand rvalue) {
        throw this.unknownProperty("ecm:ancestorId");
    }

    protected Boolean walkIsTrashed(Operator op, Operand rvalue) {
        throw this.unknownProperty("ecm:isTrashed");
    }

    public Object walkReference(Reference ref) {
        if (ref.cast != null) {
            throw new QueryParseException("Cannot use cast: " + ref);
        }
        Object value = this.map.get(ref.name);
        if (value instanceof Boolean) {
            value = (Boolean)value != false ? ONE : ZERO;
        }
        return value;
    }
}

