/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.clients;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.BaseSession;

public class OAuth2Client {
    public static final String NAME_FIELD = "name";
    public static final String ID_FIELD = "clientId";
    public static final String SECRET_FIELD = "clientSecret";
    public static final String REDIRECT_URI_FIELD = "redirectURIs";
    public static final String AUTO_GRANT_FIELD = "autoGrant";
    public static final String ENABLED_FIELD = "enabled";
    public static final String REDIRECT_URI_SEPARATOR = ",";
    protected static final Pattern LOCALHOST_PATTERN = Pattern.compile("http://localhost(:\\d+)?(/.*)?");
    protected String name;
    protected String id;
    protected String secret;
    protected List<String> redirectURIs;
    protected boolean autoGrant;
    protected boolean enabled;

    protected OAuth2Client(String name, String id, String secret, List<String> redirectURIs, boolean autoGrant, boolean enabled) {
        this.name = name;
        this.id = id;
        this.secret = secret;
        this.redirectURIs = redirectURIs;
        this.autoGrant = autoGrant;
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getRedirectURIs() {
        return this.redirectURIs;
    }

    public boolean isAutoGrant() {
        return this.autoGrant;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getSecret() {
        return this.secret;
    }

    public static OAuth2Client fromDocumentModel(DocumentModel doc) {
        String name = (String)doc.getProperty("oauth2Client", NAME_FIELD);
        String id = (String)doc.getProperty("oauth2Client", ID_FIELD);
        boolean autoGrant = Objects.requireNonNullElse((Boolean)doc.getProperty("oauth2Client", AUTO_GRANT_FIELD), false);
        boolean enabled = Objects.requireNonNullElse((Boolean)doc.getProperty("oauth2Client", ENABLED_FIELD), false);
        String redirectURIsProperty = Objects.requireNonNullElse((String)doc.getProperty("oauth2Client", REDIRECT_URI_FIELD), "");
        List<String> redirectURIs = Arrays.asList(StringUtils.split((String)redirectURIsProperty, (String)REDIRECT_URI_SEPARATOR));
        String secret = (String)doc.getProperty("oauth2Client", SECRET_FIELD);
        return new OAuth2Client(name, id, secret, redirectURIs, autoGrant, enabled);
    }

    public static boolean isRedirectURIValid(String redirectURI) {
        String trimmed = redirectURI.trim();
        return !trimmed.isEmpty() && (trimmed.startsWith("https") || !trimmed.startsWith("http") || LOCALHOST_PATTERN.matcher(trimmed).matches());
    }

    public boolean isValidWith(String clientId, String clientSecret) {
        return this.enabled && this.id.equals(clientId) && (StringUtils.isEmpty((CharSequence)this.secret) || this.secret.equals(clientSecret));
    }

    public static DocumentModel fromOAuth2Client(OAuth2Client oAuth2Client) {
        return BaseSession.createEntryModel(null, (String)"oauth2Client", null, OAuth2Client.toMap(oAuth2Client));
    }

    public static DocumentModel updateDocument(DocumentModel documentModel, OAuth2Client oAuth2Client) {
        Objects.requireNonNull(documentModel, "documentModel model is required");
        documentModel.setProperties("oauth2Client", OAuth2Client.toMap(oAuth2Client));
        return documentModel;
    }

    public static Map<String, Object> toMap(OAuth2Client oAuth2Client) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(NAME_FIELD, oAuth2Client.getName());
        values.put(ID_FIELD, oAuth2Client.getId());
        values.put(REDIRECT_URI_FIELD, StringUtils.join(oAuth2Client.getRedirectURIs(), (String)REDIRECT_URI_SEPARATOR));
        values.put(AUTO_GRANT_FIELD, oAuth2Client.isAutoGrant());
        values.put(ENABLED_FIELD, oAuth2Client.isEnabled());
        if (StringUtils.isNotEmpty((CharSequence)oAuth2Client.getSecret())) {
            values.put(SECRET_FIELD, oAuth2Client.getSecret());
        }
        return values;
    }

    public String toString() {
        return String.format("%s(name=%s, id=%s, redirectURIs=%s, autoGrant=%b, enabled=%b)", this.getClass().getSimpleName(), this.name, this.id, this.redirectURIs, this.autoGrant, this.enabled);
    }
}

