/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.providers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

public class OAuth2ServiceUserStore {
    protected static final Log log = LogFactory.getLog(OAuth2ServiceUserStore.class);
    public static final String DIRECTORY_NAME = "oauth2Tokens";
    public static final String ENTRY_ID = "id";
    private String serviceName;

    public OAuth2ServiceUserStore(String serviceName) {
        this.serviceName = serviceName;
    }

    public String store(String nuxeoLogin) {
        return this.store(nuxeoLogin, new HashMap<String, Object>());
    }

    public String store(String nuxeoLogin, Map<String, Object> fields) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        return (String)Framework.doPrivileged(() -> {
            try (Session session = ds.open(DIRECTORY_NAME);){
                fields.put("nuxeoLogin", nuxeoLogin);
                fields.put("serviceName", this.serviceName);
                DocumentModel entry = session.createEntry(fields);
                Long id = (Long)entry.getProperty("oauth2Token", ENTRY_ID);
                String string = id.toString();
                return string;
            }
        });
    }

    public String find(Map<String, Serializable> filter) {
        filter.put("serviceName", (Serializable)((Object)this.serviceName));
        DocumentModelList entries = this.query(filter);
        if (entries == null || entries.size() == 0) {
            return null;
        }
        if (entries.size() > 1) {
            log.error((Object)"Found several tokens");
        }
        Long id = (Long)((DocumentModel)entries.get(0)).getProperty("oauth2Token", ENTRY_ID);
        return id.toString();
    }

    protected DocumentModelList query(Map<String, Serializable> filter) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        return (DocumentModelList)Framework.doPrivileged(() -> {
            try (Session session = ds.open(DIRECTORY_NAME);){
                DocumentModelList documentModelList = session.query(filter);
                return documentModelList;
            }
        });
    }
}

