/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.request;

import java.io.Serializable;
import java.security.Principal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.CharacterPredicates;
import org.apache.commons.text.RandomStringGenerator;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.platform.oauth2.Constants;
import org.nuxeo.ecm.platform.oauth2.OAuth2Error;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2Client;
import org.nuxeo.ecm.platform.oauth2.clients.OAuth2ClientService;
import org.nuxeo.ecm.platform.oauth2.request.OAuth2Request;
import org.nuxeo.runtime.api.Framework;

public class AuthorizationRequest
extends OAuth2Request {
    private static final Log log = LogFactory.getLog(AuthorizationRequest.class);
    private static final RandomStringGenerator GENERATOR = new RandomStringGenerator.Builder().filteredBy(new CharacterPredicate[]{CharacterPredicates.LETTERS, CharacterPredicates.DIGITS}).withinRange(48, 122).build();
    public static final String MISSING_REQUIRED_FIELD_MESSAGE = "Missing required field \"%s\".";
    public static final String STORE_NAME = "authorizationRequestStore";
    protected String responseType;
    protected String scope;
    protected Date creationDate;
    protected String authorizationCode;
    protected String username;
    protected String codeChallenge;
    protected String codeChallengeMethod;

    public static AuthorizationRequest fromRequest(HttpServletRequest request) {
        return new AuthorizationRequest(request);
    }

    public static AuthorizationRequest fromMap(Map<String, Serializable> map) {
        return new AuthorizationRequest(map);
    }

    public static void store(String key, AuthorizationRequest authorizationRequest) {
        TransientStoreService transientStoreService = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore store = transientStoreService.getStore(STORE_NAME);
        store.putParameters(key, authorizationRequest.toMap());
    }

    public static AuthorizationRequest get(String key) {
        TransientStoreService transientStoreService = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore store = transientStoreService.getStore(STORE_NAME);
        Map parameters = store.getParameters(key);
        if (parameters != null) {
            AuthorizationRequest authorizationRequest = AuthorizationRequest.fromMap(parameters);
            return authorizationRequest.isExpired() ? null : authorizationRequest;
        }
        return null;
    }

    public static void remove(String key) {
        TransientStoreService transientStoreService = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore store = transientStoreService.getStore(STORE_NAME);
        store.remove(key);
    }

    protected AuthorizationRequest(HttpServletRequest request) {
        super(request);
        this.responseType = request.getParameter("response_type");
        this.scope = request.getParameter("scope");
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            this.username = principal.getName();
        }
        this.creationDate = new Date();
        this.codeChallenge = request.getParameter("code_challenge");
        this.codeChallengeMethod = request.getParameter("code_challenge_method");
    }

    protected AuthorizationRequest(Map<String, Serializable> map) {
        this.clientId = (String)((Object)map.get("clientId"));
        this.redirectURI = (String)((Object)map.get("redirectURI"));
        this.responseType = (String)((Object)map.get("responseType"));
        this.scope = (String)((Object)map.get("scope"));
        this.creationDate = (Date)map.get("creationDate");
        this.authorizationCode = (String)((Object)map.get("authorizationCode"));
        this.username = (String)((Object)map.get("username"));
        this.codeChallenge = (String)((Object)map.get("codeChallenge"));
        this.codeChallengeMethod = (String)((Object)map.get("codeChallengeMethod"));
    }

    public OAuth2Error checkError() {
        String clientRedirectURI;
        List<String> clientRedirectURIs;
        if (StringUtils.isBlank((CharSequence)this.clientId)) {
            return OAuth2Error.invalidRequest(String.format(MISSING_REQUIRED_FIELD_MESSAGE, "client_id"));
        }
        if (StringUtils.isBlank((CharSequence)this.responseType)) {
            return OAuth2Error.invalidRequest(String.format(MISSING_REQUIRED_FIELD_MESSAGE, "response_type"));
        }
        if (!"code".equals(this.responseType)) {
            return OAuth2Error.unsupportedResponseType(String.format("Unknown %s: got \"%s\", expecting \"%s\".", "response_type", this.responseType, "code"));
        }
        OAuth2ClientService clientService = (OAuth2ClientService)Framework.getService(OAuth2ClientService.class);
        OAuth2Client client = clientService.getClient(this.clientId);
        if (client == null) {
            return OAuth2Error.invalidRequest(String.format("Invalid %s: %s.", "client_id", this.clientId));
        }
        if (!client.isEnabled()) {
            return OAuth2Error.accessDenied(String.format("Client %s is disabled.", this.clientId));
        }
        String clientName = client.getName();
        if (StringUtils.isBlank((CharSequence)clientName)) {
            log.error((Object)String.format("No name set for OAuth2 client %s. It is a required field, please make sure you update this OAuth2 client.", client));
        }
        if (CollectionUtils.isEmpty(clientRedirectURIs = client.getRedirectURIs())) {
            log.error((Object)String.format("No redirect URI set for OAuth2 client %s, at least one is required. Please make sure you update this OAuth2 client.", client));
            return OAuth2Error.accessDenied("No redirect URI configured for the app.");
        }
        if (StringUtils.isBlank((CharSequence)this.redirectURI)) {
            clientRedirectURI = clientRedirectURIs.get(0);
        } else {
            if (!clientRedirectURIs.contains(this.redirectURI)) {
                return OAuth2Error.invalidRequest(String.format("Invalid %s parameter: %s. It must exactly match one of the redirect URIs configured for the app.", "redirect_uri", this.redirectURI));
            }
            clientRedirectURI = this.redirectURI;
        }
        if (!OAuth2Client.isRedirectURIValid(clientRedirectURI)) {
            log.error((Object)String.format("The redirect URI %s set for OAuth2 client %s is invalid: it must not be empty and start with https for security reasons. Please make sure you update this OAuth2 client.", clientRedirectURI, client));
            return OAuth2Error.invalidRequest(String.format("Invalid redirect URI configured for the app: %s. It must not be empty and start with https for security reasons.", clientRedirectURI));
        }
        if (this.codeChallenge != null && this.codeChallengeMethod == null || this.codeChallenge == null && this.codeChallengeMethod != null) {
            return OAuth2Error.invalidRequest(String.format("Invalid PKCE parameters: either both %s and %s parameters must be sent or none of them.", "code_challenge", "code_challenge_method"));
        }
        if (this.codeChallengeMethod != null && !Constants.CODE_CHALLENGE_METHODS_SUPPORTED.contains(this.codeChallengeMethod)) {
            return OAuth2Error.invalidRequest(String.format("Invalid %s parameter: transform algorithm %s not supported. The server only supports %s.", "code_challenge_method", this.codeChallengeMethod, Constants.CODE_CHALLENGE_METHODS_SUPPORTED));
        }
        return null;
    }

    public boolean isExpired() {
        return new Date().getTime() - this.creationDate.getTime() > 600000L;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public String getScope() {
        return this.scope;
    }

    public String getUsername() {
        return this.username;
    }

    public String getAuthorizationCode() {
        if (StringUtils.isBlank((CharSequence)this.authorizationCode)) {
            this.authorizationCode = GENERATOR.generate(10);
        }
        return this.authorizationCode;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public Map<String, Serializable> toMap() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        if (this.clientId != null) {
            map.put("clientId", (Serializable)((Object)this.clientId));
        }
        if (this.redirectURI != null) {
            map.put("redirectURI", (Serializable)((Object)this.redirectURI));
        }
        if (this.responseType != null) {
            map.put("responseType", (Serializable)((Object)this.responseType));
        }
        if (this.scope != null) {
            map.put("scope", (Serializable)((Object)this.scope));
        }
        if (this.creationDate != null) {
            map.put("creationDate", this.creationDate);
        }
        if (this.authorizationCode != null) {
            map.put("authorizationCode", (Serializable)((Object)this.authorizationCode));
        }
        if (this.username != null) {
            map.put("username", (Serializable)((Object)this.username));
        }
        if (this.codeChallenge != null) {
            map.put("codeChallenge", (Serializable)((Object)this.codeChallenge));
        }
        if (this.codeChallengeMethod != null) {
            map.put("codeChallengeMethod", (Serializable)((Object)this.codeChallengeMethod));
        }
        return map;
    }

    public boolean isCodeVerifierValid(String codeVerifier) {
        if (this.codeChallenge == null || this.codeChallengeMethod == null) {
            return false;
        }
        switch (this.codeChallengeMethod) {
            case "S256": {
                return this.codeChallenge.equals(Base64.encodeBase64URLSafeString((byte[])DigestUtils.sha256((String)codeVerifier)));
            }
            case "plain": {
                return this.codeChallenge.equals(codeVerifier);
            }
        }
        return false;
    }
}

