/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import javax.naming.NamingException;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.Evaluator;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;
import org.apache.directory.server.core.partition.impl.btree.LeafEvaluator;
import org.apache.directory.server.core.partition.impl.btree.ScopeEvaluator;
import org.apache.directory.server.core.partition.impl.btree.SubstringEvaluator;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;

public class ExpressionEvaluator
implements Evaluator {
    private LeafEvaluator leafEvaluator;

    public ExpressionEvaluator(LeafEvaluator leafEvaluator) {
        this.leafEvaluator = leafEvaluator;
    }

    public ExpressionEvaluator(BTreePartition db, OidRegistry oidRegistry, AttributeTypeRegistry attributeTypeRegistry) {
        ScopeEvaluator scopeEvaluator = null;
        SubstringEvaluator substringEvaluator = null;
        scopeEvaluator = new ScopeEvaluator(db);
        substringEvaluator = new SubstringEvaluator(db, oidRegistry, attributeTypeRegistry);
        this.leafEvaluator = new LeafEvaluator(db, oidRegistry, attributeTypeRegistry, scopeEvaluator, substringEvaluator);
    }

    public LeafEvaluator getLeafEvaluator() {
        return this.leafEvaluator;
    }

    public boolean evaluate(ExprNode node, IndexRecord record) throws NamingException {
        if (node.isLeaf()) {
            return this.leafEvaluator.evaluate(node, record);
        }
        BranchNode bnode = (BranchNode)node;
        switch (bnode.getOperator()) {
            case OR: {
                for (ExprNode child : bnode.getChildren()) {
                    if (!this.evaluate(child, record)) continue;
                    return true;
                }
                return false;
            }
            case AND: {
                for (ExprNode child : bnode.getChildren()) {
                    if (this.evaluate(child, record)) continue;
                    return false;
                }
                return true;
            }
            case NOT: {
                if (null != bnode.getChild()) {
                    return !this.evaluate(bnode.getChild(), record);
                }
                throw new NamingException("Negation has no child: " + node);
            }
        }
        throw new NamingException("Unrecognized branch node operator: " + bnode.getOperator());
    }
}

