/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.migrator.AbstractRepositoryMigrator;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.platform.tag.TagServiceImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.migration.MigrationService;

public class TagsMigrator
extends AbstractRepositoryMigrator {
    private static final Log log = LogFactory.getLog(TagsMigrator.class);
    protected static final String QUERY_TAGGING = "SELECT ecm:uuid, relation:source, ecm:name, dc:creator FROM Tagging WHERE ecm:isProxy = 0";
    protected static final int BATCH_SIZE = 50;

    public void notifyStatusChange() {
        TagServiceImpl tagService = (TagServiceImpl)((Object)Framework.getService(TagServiceImpl.class));
        tagService.invalidateTagServiceImplementation();
    }

    public String probeState() {
        List repositoryNames = ((RepositoryService)Framework.getService(RepositoryService.class)).getRepositoryNames();
        if (repositoryNames.stream().map(arg_0 -> ((TagsMigrator)this).probeRepository(arg_0)).anyMatch(Predicate.isEqual("relations"))) {
            return "relations";
        }
        return "facets";
    }

    protected String probeSession(CoreSession session) {
        PartialList taggingMaps = session.queryProjection(QUERY_TAGGING, 1L, 0L);
        if (!taggingMaps.isEmpty()) {
            return "relations";
        }
        return "facets";
    }

    public void run(String step, MigrationService.MigrationContext migrationContext) {
        if (!"relations-to-facets".equals(step)) {
            throw new NuxeoException("Unknown migration step: " + step);
        }
        this.migrationContext = migrationContext;
        this.reportProgress("Initializing", 0L, -1L);
        List repositoryNames = ((RepositoryService)Framework.getService(RepositoryService.class)).getRepositoryNames();
        try {
            repositoryNames.forEach(repoName -> this.migrateRepository(step, migrationContext, (String)repoName));
        }
        catch (AbstractRepositoryMigrator.MigrationShutdownException e) {
            return;
        }
    }

    protected void migrateSession(String step, MigrationService.MigrationContext migrationContext, CoreSession session) {
        PartialList taggingMaps = session.queryProjection(QUERY_TAGGING, -1L, 0L);
        this.checkShutdownRequested(migrationContext);
        String tagSql = "SELECT ecm:uuid FROM Tag WHERE ecm:isProxy = 0";
        PartialList tagMaps = session.queryProjection(tagSql, -1L, 0L);
        this.checkShutdownRequested(migrationContext);
        HashMap<String, Set> docTags = new HashMap<String, Set>();
        for (Map map2 : taggingMaps) {
            String docId2 = (String)map2.get("relation:source");
            String label = (String)map2.get("ecm:name");
            String username = (String)map2.get("dc:creator");
            Tag tag = new Tag(label, username);
            docTags.computeIfAbsent(docId2, key -> new HashSet()).add(tag);
        }
        Set taggingIds = taggingMaps.stream().map(map -> (String)map.get("ecm:uuid")).collect(Collectors.toSet());
        Set tagIds = tagMaps.stream().map(map -> (String)map.get("ecm:uuid")).collect(Collectors.toSet());
        this.checkShutdownRequested(migrationContext);
        this.processBatched(migrationContext, 50, docTags.entrySet(), es -> this.addTags(session, (String)es.getKey(), (Set)es.getValue()), "Creating new tags");
        this.processBatched(migrationContext, 50, taggingIds, docId -> this.removeDocument(session, (String)docId), "Deleting old Tagging documents");
        this.processBatched(migrationContext, 50, tagIds, docId -> this.removeDocument(session, (String)docId), "Deleting old Tag documents");
        this.reportProgress("Done", docTags.size(), docTags.size());
    }

    protected void removeDocument(CoreSession session, String docId) {
        try {
            session.removeDocument((DocumentRef)new IdRef(docId));
        }
        catch (DocumentNotFoundException e) {
            return;
        }
    }

    protected void addTags(CoreSession session, String docId, Set<Tag> tags) {
        DocumentModel doc;
        try {
            if (docId == null) {
                log.debug((Object)"docId found null in addTags");
                return;
            }
            doc = session.getDocument((DocumentRef)new IdRef(docId));
        }
        catch (DocumentNotFoundException e) {
            return;
        }
        this.addTags(doc, tags);
    }

    protected void addTags(DocumentModel doc, Set<Tag> tags) {
        List tagsList;
        if (doc.isProxy()) {
            return;
        }
        try {
            tagsList = (List)((Object)doc.getPropertyValue("nxtag:tags"));
        }
        catch (PropertyNotFoundException e) {
            return;
        }
        boolean changed = false;
        for (Tag tag : tags) {
            if (!tagsList.stream().noneMatch(t -> tag.label.equals(t.get("label")))) continue;
            HashMap<String, String> tagMap = new HashMap<String, String>(2);
            tagMap.put("label", tag.label);
            tagMap.put("username", tag.username);
            tagsList.add(tagMap);
            changed = true;
        }
        if (changed) {
            doc.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
            doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
            doc.setPropertyValue("nxtag:tags", (Serializable)((Object)tagsList));
            doc.getCoreSession().saveDocument(doc);
        }
    }

    protected static class Tag {
        protected final String label;
        protected final String username;

        public Tag(String label, String username) {
            this.label = label;
            this.username = username;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Tag)) {
                return false;
            }
            Tag other = (Tag)obj;
            if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
                return false;
            }
            return !(this.username == null ? other.username != null : !this.username.equals(other.username));
        }

        public String toString() {
            return "Tag(" + this.label + "," + this.username + ")";
        }
    }
}

