/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag.automation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.tag.TagService;

@Operation(id="Tag.Suggestion", category="Services", label="Get tag suggestion", description="Get tag suggestion")
public class SuggestTagEntry {
    public static final String ID = "Tag.Suggestion";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession documentManager;
    @Context
    protected TagService tagService;
    @Param(name="searchTerm", required=false)
    protected String searchTerm;
    @Param(name="value", required=false)
    protected String value;
    @Param(name="xpath", required=false)
    protected String xpath;
    @Param(name="document", required=false)
    protected DocumentModel doc;

    @OperationMethod
    public Blob run() throws IOException {
        ArrayList result;
        block3: {
            block4: {
                result = new ArrayList();
                if (this.tagService == null || !this.tagService.isEnabled()) break block3;
                if (StringUtils.isEmpty((CharSequence)this.value)) break block4;
                if (this.doc == null) {
                    return null;
                }
                String docId = this.doc.getId();
                ArrayList tags = new ArrayList(this.tagService.getTags(this.documentManager, docId));
                Collections.sort(tags);
                for (String tag : tags) {
                    LinkedHashMap<String, String> obj = new LinkedHashMap<String, String>();
                    obj.put("id", tag);
                    obj.put("displayLabel", tag);
                    result.add(obj);
                }
                break block3;
            }
            if (StringUtils.isBlank((CharSequence)this.searchTerm)) break block3;
            ArrayList tags = new ArrayList(this.tagService.getSuggestions(this.documentManager, this.searchTerm));
            Collections.sort(tags);
            for (int i = 0; i < 10 && i < tags.size(); ++i) {
                LinkedHashMap<String, String> obj = new LinkedHashMap<String, String>();
                String tag = (String)tags.get(i);
                obj.put("id", tag);
                obj.put("displayLabel", tag);
                result.add(obj);
            }
        }
        return Blobs.createJSONBlobFromValue(result);
    }
}

