/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.MetricSet;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.dropwizard.metrics5.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.logging.SequenceTracer;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.work.NuxeoBlockingQueue;
import org.nuxeo.ecm.core.work.WorkHolder;
import org.nuxeo.ecm.core.work.WorkQueuing;
import org.nuxeo.ecm.core.work.WorkStateHelper;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.core.work.api.WorkQueueDescriptor;
import org.nuxeo.ecm.core.work.api.WorkQueueMetrics;
import org.nuxeo.ecm.core.work.api.WorkQueuingDescriptor;
import org.nuxeo.ecm.core.work.api.WorkSchedulePath;
import org.nuxeo.lib.stream.codec.AvroMessageCodec;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.metrics.NuxeoMetricSet;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Descriptor;
import org.nuxeo.runtime.model.DescriptorRegistry;
import org.nuxeo.runtime.services.config.ConfigurationService;
import org.nuxeo.runtime.stream.StreamService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class WorkManagerImpl
extends DefaultComponent
implements WorkManager {
    private static final Logger log = LogManager.getLogger(WorkManagerImpl.class);
    public static final String NAME = "org.nuxeo.ecm.core.work.service";
    protected static final String QUEUES_EP = "queues";
    protected static final String IMPL_EP = "implementation";
    public static final String DEFAULT_QUEUE_ID = "default";
    public static final String DEFAULT_CATEGORY = "default";
    protected static final String THREAD_PREFIX = "Nuxeo-Work-";
    public static final String SHUTDOWN_DELAY_MS_KEY = "nuxeo.work.shutdown.delay.ms";
    public static final String WORKMANAGER_PROCESSING_DISABLE = "nuxeo.work.processing.disable";
    public static final String DEFAULT_LOG_MANAGER = "default";
    public static final String DEAD_LETTER_QUEUE = "dlq-work";
    public static final Codec<Record> DEAD_LETTER_QUEUE_CODEC = new AvroMessageCodec(Record.class);
    protected static final String GLOBAL_METRIC_PREFIX = "nuxeo.works.global.queue";
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Map<String, WorkThreadPoolExecutor> executors = new HashMap<String, WorkThreadPoolExecutor>();
    protected final Map<String, String> categoryToQueueId = new HashMap<String, String>();
    protected WorkQueuing queuing;
    protected boolean active = true;
    protected WorkCompletionSynchronizer completionSynchronizer;
    protected volatile boolean started = false;
    protected volatile boolean shutdownInProgress = false;

    public WorkManagerImpl() {
        super.setName(NAME);
    }

    public void setName(String name) {
    }

    public void registerContribution(Object contribution, String xp, ComponentInstance component) {
        if (QUEUES_EP.equals(xp)) {
            WorkQueueDescriptor descriptor = (WorkQueueDescriptor)contribution;
            if ("*".equals(descriptor.getId())) {
                Boolean processing = descriptor.processing;
                if (processing == null) {
                    log.error("Ignoring work queue descriptor {} with no processing/queuing", (Object)"*");
                    return;
                }
                log.info("Setting on all work queues:{}", new Supplier[]{() -> " processing=" + processing + (String)(this.queuing == null ? "" : " queuing=" + this.queuing)});
                this.getDescriptors(QUEUES_EP).forEach(d -> {
                    WorkQueueDescriptor wqd = new WorkQueueDescriptor();
                    wqd.id = d.getId();
                    wqd.processing = processing;
                    this.register(QUEUES_EP, wqd);
                });
            } else {
                this.register(QUEUES_EP, descriptor);
            }
        } else {
            super.registerContribution(contribution, xp, component);
        }
    }

    void initializeQueue(WorkQueueDescriptor config) {
        if ("*".equals(config.id)) {
            throw new IllegalArgumentException("cannot initialize all queues");
        }
        if (this.queuing.getQueue(config.id) != null) {
            throw new IllegalStateException("work queue " + config.id + " is already initialized");
        }
        if (this.executors.containsKey(config.id)) {
            throw new IllegalStateException("work queue " + config.id + " already have an executor");
        }
        NuxeoBlockingQueue queue = this.queuing.init(config);
        NamedThreadFactory threadFactory = new NamedThreadFactory(THREAD_PREFIX + config.id + "-");
        int maxPoolSize = config.getMaxThreads();
        WorkThreadPoolExecutor executor = new WorkThreadPoolExecutor(maxPoolSize, maxPoolSize, 0L, TimeUnit.SECONDS, queue, threadFactory);
        executor.prestartAllCoreThreads();
        this.executors.put(config.id, executor);
        log.info("Initialized work queue {}, {}", (Object)config.id, (Object)config);
    }

    void activateQueue(WorkQueueDescriptor config) {
        if ("*".equals(config.id)) {
            throw new IllegalArgumentException("cannot activate all queues");
        }
        this.queuing.setActive(config.id, config.isProcessingEnabled());
        log.info("Activated work queue {}, {}", (Object)config.id, (Object)config);
        if (config.isProcessingEnabled()) {
            this.activateQueueMetrics(config.id);
        }
    }

    void deactivateQueue(WorkQueueDescriptor config) {
        if ("*".equals(config.id)) {
            throw new IllegalArgumentException("cannot deactivate all queues");
        }
        if (config.isProcessingEnabled()) {
            this.deactivateQueueMetrics(config.id);
        }
        this.queuing.setActive(config.id, false);
        log.info("Deactivated work queue {}", (Object)config.id);
    }

    void activateQueueMetrics(String queueId) {
        NuxeoMetricSet queueMetrics = new NuxeoMetricSet(MetricName.build((String[])new String[]{GLOBAL_METRIC_PREFIX}).tagged(new String[]{"queue", queueId}));
        queueMetrics.putGauge(() -> this.getMetrics((String)queueId).scheduled, "scheduled", new String[0]);
        queueMetrics.putGauge(() -> this.getMetrics((String)queueId).running, "running", new String[0]);
        queueMetrics.putGauge(() -> this.getMetrics((String)queueId).completed, "completed", new String[0]);
        queueMetrics.putGauge(() -> this.getMetrics((String)queueId).canceled, "canceled", new String[0]);
        this.registry.registerAll((MetricSet)queueMetrics);
    }

    void deactivateQueueMetrics(String queueId) {
        String queueMetricsName = MetricName.build((String[])new String[]{GLOBAL_METRIC_PREFIX}).tagged(new String[]{"queue", queueId}).getKey();
        this.registry.removeMatching((name, metric) -> name.getKey().startsWith(queueMetricsName));
    }

    @Override
    public boolean isQueuingEnabled(String queueId) {
        WorkQueueDescriptor wqd = this.getWorkQueueDescriptor(queueId);
        return wqd != null && wqd.isQueuingEnabled();
    }

    @Override
    public void enableProcessing(boolean value) {
        this.getDescriptors(QUEUES_EP).forEach(d -> this.enableProcessing(d.getId(), value));
    }

    @Override
    public void enableProcessing(String queueId, boolean value) {
        WorkQueueDescriptor config = (WorkQueueDescriptor)this.getDescriptor(QUEUES_EP, queueId);
        if (config == null) {
            throw new IllegalArgumentException("no such queue " + queueId);
        }
        if (!value) {
            if (!this.queuing.supportsProcessingDisabling()) {
                log.error("Attempting to disable works processing on a WorkQueuing instance that does not support it. Works will still be processed. Disabling works processing to manage distribution finely can be done using Redis or Stream implementations.");
            }
            this.deactivateQueue(config);
        } else {
            this.activateQueue(config);
        }
    }

    @Override
    public boolean isProcessingEnabled() {
        if (Boolean.parseBoolean(Framework.getProperty((String)WORKMANAGER_PROCESSING_DISABLE, (String)"false"))) {
            return false;
        }
        for (Descriptor d : this.getDescriptors(QUEUES_EP)) {
            if (!this.queuing.getQueue((String)d.getId()).active) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isProcessingEnabled(String queueId) {
        if (Boolean.parseBoolean(Framework.getProperty((String)WORKMANAGER_PROCESSING_DISABLE, (String)"false"))) {
            return false;
        }
        if (queueId == null) {
            return this.isProcessingEnabled();
        }
        return this.queuing.getQueue((String)queueId).active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getWorkQueueIds() {
        DescriptorRegistry descriptorRegistry = this.getRegistry();
        synchronized (descriptorRegistry) {
            return this.getDescriptors(QUEUES_EP).stream().map(Descriptor::getId).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkQueueDescriptor getWorkQueueDescriptor(String queueId) {
        DescriptorRegistry descriptorRegistry = this.getRegistry();
        synchronized (descriptorRegistry) {
            return (WorkQueueDescriptor)this.getDescriptor(QUEUES_EP, queueId);
        }
    }

    @Override
    public String getCategoryQueueId(String category) {
        String queueId;
        if (category == null) {
            category = "default";
        }
        if ((queueId = this.categoryToQueueId.get(category)) == null) {
            queueId = "default";
        }
        return queueId;
    }

    public int getApplicationStartedOrder() {
        return -501;
    }

    public void start(ComponentContext context) {
        super.start(context);
        this.initDeadLetterQueueStream();
        this.init();
    }

    protected void initDeadLetterQueueStream() {
        StreamService service = (StreamService)Framework.getService(StreamService.class);
        if (service == null) {
            return;
        }
        try {
            org.nuxeo.lib.stream.log.LogManager logManager = service.getLogManager("default");
            if (!logManager.exists(DEAD_LETTER_QUEUE)) {
                log.info("Initializing dead letter queue to store Work in failure");
                logManager.createIfNotExists(DEAD_LETTER_QUEUE, 1);
            }
            logManager.getAppender(DEAD_LETTER_QUEUE, DEAD_LETTER_QUEUE_CODEC);
        }
        catch (IllegalArgumentException e) {
            log.info("No default LogManager found, there will be no dead letter queuing for Work in failure.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.started || !this.active) {
            return;
        }
        WorkManagerImpl workManagerImpl = this;
        synchronized (workManagerImpl) {
            if (this.started) {
                return;
            }
            WorkQueuingDescriptor d = (WorkQueuingDescriptor)this.getDescriptor(IMPL_EP, "");
            try {
                this.queuing = d.klass.getDeclaredConstructor(WorkQueuing.Listener.class).newInstance(WorkQueuing.Listener.lookupListener());
            }
            catch (ReflectiveOperationException | SecurityException e) {
                throw new RuntimeException(e);
            }
            this.completionSynchronizer = new WorkCompletionSynchronizer();
            this.started = true;
            this.index();
            List descriptors = this.getDescriptors(QUEUES_EP);
            for (WorkQueueDescriptor descriptor : descriptors) {
                this.initializeQueue(descriptor);
            }
            Framework.getRuntime().getComponentManager().addListener(new ComponentManager.Listener(){

                public void beforeStop(ComponentManager mgr, boolean isStandby) {
                    List descriptors = WorkManagerImpl.this.getDescriptors(WorkManagerImpl.QUEUES_EP);
                    for (WorkQueueDescriptor descriptor : descriptors) {
                        WorkManagerImpl.this.deactivateQueue(descriptor);
                    }
                    try {
                        if (!WorkManagerImpl.this.shutdown(10L, TimeUnit.SECONDS)) {
                            log.error("Some processors are still active");
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new NuxeoException("Interrupted while stopping work manager thread pools", (Throwable)e);
                    }
                }

                public void afterStart(ComponentManager mgr, boolean isResume) {
                    if (Boolean.parseBoolean(Framework.getProperty((String)WorkManagerImpl.WORKMANAGER_PROCESSING_DISABLE, (String)"false"))) {
                        log.warn("WorkManager processing has been disabled on this node");
                        return;
                    }
                    List descriptors = WorkManagerImpl.this.getDescriptors(WorkManagerImpl.QUEUES_EP);
                    for (WorkQueueDescriptor descriptor : descriptors) {
                        WorkManagerImpl.this.activateQueue(descriptor);
                    }
                }

                public void afterStop(ComponentManager mgr, boolean isStandby) {
                    Framework.getRuntime().getComponentManager().removeListener((ComponentManager.Listener)this);
                }
            });
        }
    }

    protected void index() {
        List descriptors = this.getDescriptors(QUEUES_EP);
        descriptors.forEach(d -> d.categories.forEach(c -> {
            this.categoryToQueueId.computeIfPresent((String)c, (k, v) -> {
                if (!v.equals(d.getId())) {
                    log.error("Work category '{}' cannot be assigned to work queue '{}' because it is already assigned to work queue '{}'", c, (Object)d.getId(), v);
                }
                return v;
            });
            this.categoryToQueueId.putIfAbsent((String)c, d.getId());
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkThreadPoolExecutor getExecutor(String queueId) {
        WorkQueueDescriptor workQueueDescriptor;
        if (!this.started) {
            if (Framework.isTestModeSet() && !Framework.getRuntime().isShuttingDown()) {
                LogFactory.getLog(WorkManagerImpl.class).warn((Object)"Lazy starting of work manager in test mode");
                this.init();
            } else {
                throw new IllegalStateException("Work manager not started, could not access to executors");
            }
        }
        DescriptorRegistry descriptorRegistry = this.getRegistry();
        synchronized (descriptorRegistry) {
            workQueueDescriptor = (WorkQueueDescriptor)this.getDescriptor(QUEUES_EP, queueId);
        }
        if (workQueueDescriptor == null) {
            throw new IllegalArgumentException("No such work queue: " + queueId);
        }
        return this.executors.get(queueId);
    }

    @Override
    public boolean shutdownQueue(String queueId, long timeout, TimeUnit unit) throws InterruptedException {
        WorkThreadPoolExecutor executor = this.getExecutor(queueId);
        return this.shutdownExecutors(Collections.singleton(executor), timeout, unit);
    }

    protected boolean shutdownExecutors(Collection<WorkThreadPoolExecutor> list, long timeout, TimeUnit unit) throws InterruptedException {
        for (WorkThreadPoolExecutor executor : list) {
            executor.shutdownAndSuspend();
        }
        timeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
        for (WorkThreadPoolExecutor executor : list) {
            long t0 = System.currentTimeMillis();
            if (!executor.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                return false;
            }
            timeout -= System.currentTimeMillis() - t0;
        }
        return true;
    }

    @Deprecated
    protected long remainingMillis(long t0, long delay) {
        long d = System.currentTimeMillis() - t0;
        if (d > delay) {
            return 0L;
        }
        return delay - d;
    }

    @Deprecated
    protected synchronized void removeExecutor(String queueId) {
        this.executors.remove(queueId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        this.shutdownInProgress = true;
        try {
            boolean bl = this.shutdownExecutors(new ArrayList<WorkThreadPoolExecutor>(this.executors.values()), timeout, unit);
            return bl;
        }
        finally {
            this.shutdownInProgress = false;
            this.started = false;
        }
    }

    @Override
    public void schedule(Work work) {
        this.schedule(work, WorkManager.Scheduling.ENQUEUE, false);
    }

    @Override
    public void schedule(Work work, boolean afterCommit) {
        this.schedule(work, WorkManager.Scheduling.ENQUEUE, afterCommit);
    }

    @Override
    public void schedule(Work work, WorkManager.Scheduling scheduling) {
        this.schedule(work, scheduling, false);
    }

    @Override
    public void schedule(Work work, WorkManager.Scheduling scheduling, boolean afterCommit) {
        String workId = work.getId();
        String queueId = this.getCategoryQueueId(work.getCategory());
        if (!this.isQueuingEnabled(queueId)) {
            return;
        }
        if (afterCommit && this.scheduleAfterCommit(work, scheduling)) {
            return;
        }
        work.setWorkInstanceState(Work.State.SCHEDULED);
        WorkSchedulePath.newInstance(work);
        switch (scheduling) {
            case ENQUEUE: {
                break;
            }
            case CANCEL_SCHEDULED: {
                this.getExecutor(queueId).removeScheduled(workId);
                WorkStateHelper.setCanceled(work.getId());
                break;
            }
            case IF_NOT_SCHEDULED: 
            case IF_NOT_RUNNING_OR_SCHEDULED: {
                boolean disabled = Boolean.TRUE;
                if (disabled || !this.hasWorkInState(workId, scheduling.state)) break;
                log.debug("Canceling schedule because found: {}", (Object)scheduling);
                return;
            }
        }
        if (work.isGroupJoin()) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = work::getId;
            supplierArray[1] = work::getPartitionKey;
            log.debug("Submit Work: {} to GroupJoin: {}", supplierArray);
            WorkStateHelper.addGroupJoinWork(work.getPartitionKey());
        }
        this.queuing.workSchedule(queueId, work);
    }

    protected boolean scheduleAfterCommit(Work work, WorkManager.Scheduling scheduling) {
        TransactionManager transactionManager;
        try {
            transactionManager = TransactionHelper.lookupTransactionManager();
        }
        catch (NamingException e) {
            transactionManager = null;
        }
        if (transactionManager == null) {
            log.debug("Not scheduling work after commit because of missing transaction manager: {}", (Object)work);
            return false;
        }
        try {
            Transaction transaction = transactionManager.getTransaction();
            if (transaction == null) {
                log.debug("Not scheduling work after commit because of missing transaction: {}", (Object)work);
                return false;
            }
            int status = transaction.getStatus();
            if (status == 0) {
                log.debug("Scheduling work after commit: {}", (Object)work);
                transaction.registerSynchronization((Synchronization)new WorkScheduling(work, scheduling));
                return true;
            }
            if (status == 3) {
                log.debug("Scheduling work immediately: {}", (Object)work);
                return false;
            }
            if (status == 1) {
                log.debug("Cancelling schedule because transaction marked rollback-only: {}", (Object)work);
                return true;
            }
            log.debug("Not scheduling work after commit because transaction is in status {}: {}", (Object)status, (Object)work);
            return false;
        }
        catch (RollbackException | SystemException e) {
            log.error("Cannot schedule after commit", e);
            return false;
        }
    }

    @Override
    public Work find(String workId, Work.State state) {
        return this.queuing.find(workId, state);
    }

    protected boolean hasWorkInState(String workId, Work.State state) {
        return this.queuing.isWorkInState(workId, state);
    }

    @Override
    public Work.State getWorkState(String workId) {
        return this.queuing.getWorkState(workId);
    }

    @Override
    public List<Work> listWork(String queueId, Work.State state) {
        return this.queuing.listWork(queueId, state);
    }

    @Override
    public List<String> listWorkIds(String queueId, Work.State state) {
        return this.queuing.listWorkIds(queueId, state);
    }

    @Override
    public WorkQueueMetrics getMetrics(String queueId) {
        return this.queuing.metrics(queueId);
    }

    @Override
    public int getQueueSize(String queueId, Work.State state) {
        WorkQueueMetrics metrics = this.getMetrics(queueId);
        if (state == null) {
            return metrics.scheduled.intValue() + metrics.running.intValue();
        }
        if (state == Work.State.SCHEDULED) {
            return metrics.scheduled.intValue();
        }
        if (state == Work.State.RUNNING) {
            return metrics.running.intValue();
        }
        throw new IllegalArgumentException(String.valueOf((Object)state));
    }

    @Override
    public boolean awaitCompletion(long duration, TimeUnit unit) throws InterruptedException {
        return this.awaitCompletion(null, duration, unit);
    }

    @Override
    public boolean awaitCompletion(String queueId, long duration, TimeUnit unit) throws InterruptedException {
        if (!this.isStarted()) {
            return true;
        }
        SequenceTracer.start((String)("awaitCompletion on " + (queueId == null ? "all queues" : queueId)));
        long durationInMs = TimeUnit.MILLISECONDS.convert(duration, unit);
        long deadline = this.getTimestampAfter(durationInMs);
        int pause = (int)Math.min(durationInMs, 500L);
        log.debug("awaitForCompletion {} ms", (Object)durationInMs);
        do {
            if (this.noScheduledOrRunningWork(queueId)) {
                this.completionSynchronizer.signalCompletedWork();
                SequenceTracer.stop((String)"done");
                return true;
            }
            this.completionSynchronizer.waitForCompletedWork(pause);
        } while (System.currentTimeMillis() < deadline);
        log.info("awaitCompletion timeout after {} ms", (Object)durationInMs);
        SequenceTracer.destroy((String)("timeout after " + durationInMs + " ms"));
        return false;
    }

    protected long getTimestampAfter(long durationInMs) {
        long ret = System.currentTimeMillis() + durationInMs;
        if (ret < 0L) {
            ret = Long.MAX_VALUE;
        }
        return ret;
    }

    protected boolean noScheduledOrRunningWork(String queueId) {
        if (queueId == null) {
            for (String id : this.getWorkQueueIds()) {
                if (this.noScheduledOrRunningWork(id)) continue;
                return false;
            }
            return true;
        }
        if (!this.isProcessingEnabled(queueId)) {
            return this.getExecutor((String)queueId).runningCount.getCount() == 0L;
        }
        if (this.getQueueSize(queueId, null) > 0) {
            log.trace("{} not empty, sched: {}, running: {}", new Supplier[]{() -> queueId, () -> this.getQueueSize(queueId, Work.State.SCHEDULED), () -> this.getQueueSize(queueId, Work.State.RUNNING)});
            return false;
        }
        log.trace("{} is completed", (Object)queueId);
        return true;
    }

    @Override
    public boolean isStarted() {
        return this.started && !this.shutdownInProgress;
    }

    @Override
    public boolean supportsProcessingDisabling() {
        return this.queuing.supportsProcessingDisabling();
    }

    protected class WorkThreadPoolExecutor
    extends ThreadPoolExecutor {
        protected final String queueId;
        protected final ConcurrentLinkedQueue<Work> running;
        protected final Counter scheduledCount;
        protected final Counter runningCount;
        protected final Counter completedCount;
        protected final Timer workTimer;

        protected WorkThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, NuxeoBlockingQueue queue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)queue, threadFactory);
            this.queueId = queue.queueId;
            this.running = new ConcurrentLinkedQueue();
            this.scheduledCount = WorkManagerImpl.this.registry.counter(MetricName.build((String[])new String[]{"nuxeo.works.queue.scheduled"}).tagged(new String[]{"queue", this.queueId}));
            this.runningCount = WorkManagerImpl.this.registry.counter(MetricName.build((String[])new String[]{"nuxeo.works.queue.running"}).tagged(new String[]{"queue", this.queueId}));
            this.completedCount = WorkManagerImpl.this.registry.counter(MetricName.build((String[])new String[]{"nuxeo.works.queue.completed"}).tagged(new String[]{"queue", this.queueId}));
            this.workTimer = WorkManagerImpl.this.registry.timer(MetricName.build((String[])new String[]{"nuxeo.works.queue.timer"}).tagged(new String[]{"queue", this.queueId}));
        }

        public int getScheduledOrRunningSize() {
            int ret = 0;
            for (String queueId : WorkManagerImpl.this.getWorkQueueIds()) {
                ret += WorkManagerImpl.this.getQueueSize(queueId, null);
            }
            return ret;
        }

        @Override
        public void execute(Runnable r) {
            throw new UnsupportedOperationException("use other api");
        }

        @Deprecated
        public void execute(Work work) {
            this.scheduledCount.inc();
            this.submit(work);
        }

        protected void submit(Work work) throws RuntimeException {
            WorkManagerImpl.this.queuing.workSchedule(this.queueId, work);
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            Work work = WorkHolder.getWork(r);
            if (this.isShutdown()) {
                work.setWorkInstanceState(Work.State.SCHEDULED);
                WorkManagerImpl.this.queuing.workReschedule(this.queueId, work);
                throw new RejectedExecutionException(this.queueId + " was shutdown, rescheduled " + work);
            }
            work.setWorkInstanceState(Work.State.RUNNING);
            WorkManagerImpl.this.queuing.workRunning(this.queueId, work);
            this.running.add(work);
            this.runningCount.inc();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            Work work = WorkHolder.getWork(r);
            try {
                if (work.isSuspending()) {
                    log.trace("{} is suspending, giving up", (Object)work);
                    return;
                }
                if (this.isShutdown()) {
                    log.trace("rescheduling {}", (Object)work.getId(), (Object)t);
                    work.setWorkInstanceState(Work.State.SCHEDULED);
                    WorkManagerImpl.this.queuing.workReschedule(this.queueId, work);
                    return;
                }
                work.setWorkInstanceState(Work.State.UNKNOWN);
                WorkManagerImpl.this.queuing.workCompleted(this.queueId, work);
            }
            finally {
                this.running.remove(work);
                this.runningCount.dec();
                this.completedCount.inc();
                this.workTimer.update(work.getCompletionTime() - work.getStartTime(), TimeUnit.MILLISECONDS);
                WorkManagerImpl.this.completionSynchronizer.signalCompletedWork();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdownAndSuspend() throws InterruptedException {
            try {
                WorkManagerImpl.this.deactivateQueueMetrics(this.queueId);
                WorkManagerImpl.this.queuing.setActive(this.queueId, false);
                boolean hasRunningWork = false;
                for (Work work : this.running) {
                    work.setWorkInstanceSuspending();
                    log.trace("suspending and rescheduling {}", (Object)work.getId());
                    work.setWorkInstanceState(Work.State.SCHEDULED);
                    WorkManagerImpl.this.queuing.workReschedule(this.queueId, work);
                    hasRunningWork = true;
                }
                if (hasRunningWork) {
                    long shutdownDelay = ((ConfigurationService)Framework.getService(ConfigurationService.class)).getLong(WorkManagerImpl.SHUTDOWN_DELAY_MS_KEY, 0L);
                    Thread.sleep(shutdownDelay);
                }
                this.shutdownNow();
            }
            finally {
                WorkManagerImpl.this.executors.remove(this.queueId);
            }
        }

        public void removeScheduled(String workId) {
            WorkManagerImpl.this.queuing.removeScheduled(this.queueId, workId);
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger();
        private final ThreadGroup group;
        private final String prefix;

        public NamedThreadFactory(String prefix) {
            SecurityManager sm = System.getSecurityManager();
            this.group = sm == null ? Thread.currentThread().getThreadGroup() : sm.getThreadGroup();
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = this.prefix + this.threadNumber.incrementAndGet();
            Thread thread = new Thread(this.group, r, name);
            thread.setPriority(5);
            thread.setUncaughtExceptionHandler(this::handleUncaughtException);
            return thread;
        }

        protected void handleUncaughtException(Thread t, Throwable e) {
            Log logLocal = LogFactory.getLog(WorkManagerImpl.class);
            if (e instanceof RejectedExecutionException) {
                logLocal.warn((Object)("Rejected execution error on thread " + t.getName()), e);
            } else if (ExceptionUtils.hasInterruptedCause((Throwable)e)) {
                logLocal.warn((Object)("Interrupted error on thread" + t.getName()), e);
            } else {
                logLocal.error((Object)String.format("Uncaught error on thread: %s, current work might be lost, WorkManager metrics might be corrupted.", t.getName()), e);
            }
        }
    }

    public class WorkScheduling
    implements Synchronization {
        public final Work work;
        public final WorkManager.Scheduling scheduling;

        public WorkScheduling(Work work, WorkManager.Scheduling scheduling) {
            this.work = work;
            this.scheduling = scheduling;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (status == 3) {
                WorkManagerImpl.this.schedule(this.work, this.scheduling, false);
            } else if (status == 4) {
                this.work.setWorkInstanceState(Work.State.UNKNOWN);
            } else {
                throw new IllegalArgumentException("Unsupported transaction status " + status);
            }
        }
    }

    protected class WorkCompletionSynchronizer {
        protected final ReentrantLock lock = new ReentrantLock();
        protected final Condition condition = this.lock.newCondition();

        protected WorkCompletionSynchronizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean waitForCompletedWork(long timeMs) throws InterruptedException {
            this.lock.lock();
            try {
                boolean bl = this.condition.await(timeMs, TimeUnit.MILLISECONDS);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        protected void signalCompletedWork() {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

