/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work.api;

import java.io.Serializable;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.work.api.WorkSchedulePath;

public interface Work
extends Serializable {
    public void run();

    public void work();

    public String getId();

    public void cleanUp(boolean var1, Exception var2);

    public void setWorkInstanceSuspending();

    public boolean isSuspending();

    public void suspended();

    public boolean isWorkInstanceSuspended();

    public void setWorkInstanceState(State var1);

    public State getWorkInstanceState();

    public String getCategory();

    public String getTitle();

    public String getStatus();

    public long getSchedulingTime();

    public long getStartTime();

    public long getCompletionTime();

    public void setStartTime();

    public void setProgress(Progress var1);

    public Progress getProgress();

    public String getOriginatingUsername();

    public DocumentLocation getDocument();

    public List<DocumentLocation> getDocuments();

    public boolean isDocumentTree();

    public WorkSchedulePath getSchedulePath();

    public void setSchedulePath(WorkSchedulePath var1);

    default public String getPartitionKey() {
        return this.getId();
    }

    default public boolean isIdempotent() {
        return true;
    }

    default public boolean isCoalescing() {
        return false;
    }

    default public boolean isGroupJoin() {
        return false;
    }

    default public void onGroupJoinCompletion() {
    }

    public static class Progress
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final long CURRENT_INDETERMINATE = -1L;
        public static final float PERCENT_INDETERMINATE = -1.0f;
        public static final Progress PROGRESS_INDETERMINATE = new Progress(-1.0f);
        public static final Progress PROGRESS_0_PC = new Progress(0.0f);
        public static final Progress PROGRESS_100_PC = new Progress(100.0f);
        protected final float percent;
        protected final long current;
        protected final long total;

        public Progress(float percent) {
            this.percent = percent > 100.0f ? 100.0f : percent;
            this.current = -1L;
            this.total = 0L;
        }

        public Progress(long current, long total) {
            this.percent = -1.0f;
            this.current = current;
            this.total = total;
        }

        public float getPercent() {
            return this.percent;
        }

        public long getCurrent() {
            return this.current;
        }

        public long getTotal() {
            return this.total;
        }

        public boolean getIsWithPercent() {
            return this.percent != -1.0f;
        }

        public boolean getIsWithCurrentAndTotal() {
            return this.current != -1L;
        }

        public boolean getIsIndeterminate() {
            return this.percent == -1.0f && this.current == -1L;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + (Serializable)(this.percent == -1.0f ? "?" : Float.valueOf(this.percent)) + "%, " + (Serializable)(this.current == -1L ? "?" : Long.valueOf(this.current)) + "/" + this.total + ")";
        }
    }

    public static enum State {
        UNKNOWN,
        SCHEDULED,
        RUNNING;

    }
}

