/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.local;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.AbstractSession;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class LocalSession
extends AbstractSession
implements CloseableCoreSession,
Synchronization {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(LocalSession.class);
    protected String repositoryName;
    protected NuxeoPrincipal principal;
    private static final Map<String, ThreadLocal<Session<?>>> SESSIONS = new ConcurrentHashMap(1);

    public LocalSession(String repositoryName, NuxeoPrincipal principal) {
        if (TransactionHelper.isTransactionMarkedRollback()) {
            throw new NuxeoException("Cannot create a CoreSession when transaction is marked rollback-only");
        }
        if (!TransactionHelper.isTransactionActive()) {
            throw new NuxeoException("Cannot create a CoreSession outside a transaction");
        }
        this.repositoryName = repositoryName;
        this.principal = principal;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getSessionId() {
        return this.toString();
    }

    public String toString() {
        return this.repositoryName + "/" + this.principal;
    }

    public Session<?> getSession() {
        if (!TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            throw new NuxeoException("Cannot use a CoreSession outside a transaction");
        }
        TransactionHelper.checkTransactionTimeout();
        ThreadLocal repoSessions = SESSIONS.computeIfAbsent(this.repositoryName, r -> new ThreadLocal());
        Session<?> session = (Session<?>)repoSessions.get();
        if (session == null || !session.isLive()) {
            this.closeInThisThread();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reconnecting CoreSession: " + this.toString()));
            }
            if (TransactionHelper.isTransactionMarkedRollback()) {
                throw new NuxeoException("Cannot reconnect a CoreSession when transaction is marked rollback-only");
            }
            session = this.createSession();
            repoSessions.set(session);
            TransactionHelper.registerSynchronization((Synchronization)this);
        }
        return session;
    }

    protected Session<?> createSession() {
        RepositoryService repositoryService = (RepositoryService)((Object)Framework.getService(RepositoryService.class));
        Repository repository = repositoryService.getRepository(this.repositoryName);
        if (repository == null) {
            throw new DocumentNotFoundException("No such repository: " + this.repositoryName);
        }
        Session session = repository.getSession();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding thread " + Thread.currentThread().getName() + " for CoreSession: " + this.toString()));
        }
        return session;
    }

    public void close() {
    }

    public void beforeCompletion() {
        this.closeInThisThread();
    }

    public void afterCompletion(int status) {
        if (status == 4) {
            this.closeInThisThread();
        }
    }

    protected void closeInThisThread() {
        ThreadLocal<Session<?>> repoSessions = SESSIONS.get(this.repositoryName);
        if (repoSessions == null) {
            return;
        }
        Session<?> session = repoSessions.get();
        if (session == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing thread " + Thread.currentThread().getName() + " for CoreSession: " + this.repositoryName + "/" + this.principal));
        }
        try {
            session.close();
        }
        finally {
            repoSessions.remove();
        }
    }

    public void destroy() {
    }

    public NuxeoPrincipal getPrincipal() {
        return this.principal;
    }

    public boolean isStateSharedByAllThreadSessions() {
        return true;
    }
}

