/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.versioning;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.versioning.StandardVersioningPolicyFilter;
import org.nuxeo.ecm.core.versioning.VersioningPolicyFilter;

@XObject(value="filter")
public class VersioningFilterDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(VersioningFilterDescriptor.class);
    @XNode(value="@id")
    protected String id;
    @XNode(value="@class")
    protected Class<VersioningPolicyFilter> className;
    @XNodeList(value="type", componentType=String.class, type=HashSet.class)
    protected Set<String> types = new HashSet<String>();
    @XNodeList(value="facet", componentType=String.class, type=HashSet.class)
    protected Set<String> facets = new HashSet<String>();
    @XNodeList(value="schema", componentType=String.class, type=HashSet.class)
    protected Set<String> schemas = new HashSet<String>();
    @XNode(value="condition")
    protected String condition;

    public String getId() {
        return this.id;
    }

    public VersioningPolicyFilter newInstance() {
        VersioningPolicyFilter filter = null;
        if (this.className != null) {
            try {
                filter = this.className.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)("Class " + this.className + " could not be instantiated"), (Throwable)e);
            }
        } else {
            return new StandardVersioningPolicyFilter(this.types, this.facets, this.schemas, this.condition);
        }
        return filter;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.id + ")";
    }
}

