/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.csv;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.output.AppendableOutputStream;

public class OutputStreamWithCSVWriter
extends OutputStream {
    protected AppendableOutputStream<Appendable> out;
    protected CSVPrinter csvPrinter;

    public OutputStreamWithCSVWriter() {
    }

    public OutputStreamWithCSVWriter(CSVPrinter csvPrinter) {
        this.setCSVPrinter(csvPrinter);
    }

    public void setCSVPrinter(CSVPrinter csvPrinter) {
        this.csvPrinter = csvPrinter;
        this.out = new AppendableOutputStream(csvPrinter.getOut());
    }

    @Override
    public void write(int i) throws IOException {
        this.out.write(i);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public CSVPrinter getCsvPrinter() {
        return this.csvPrinter;
    }

    public String toString() {
        return this.out.getAppendable().toString();
    }
}

