/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.nuxeo.ecm.core.io.marshallers.json.JsonFactoryProvider;
import org.nuxeo.ecm.core.io.marshallers.json.OutputStreamWithJsonWriter;
import org.nuxeo.ecm.core.io.registry.MarshallerRegistry;
import org.nuxeo.ecm.core.io.registry.MarshallingException;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Supports;

@Supports(value={"application/json"})
public abstract class AbstractJsonWriter<EntityType>
implements Writer<EntityType> {
    @Inject
    protected RenderingContext ctx;
    @Inject
    protected MarshallerRegistry registry;

    @Override
    public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
        return true;
    }

    @Override
    public void write(EntityType entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) throws IOException {
        JsonGenerator jg = this.getGenerator(out, true);
        this.write(entity, jg);
        jg.flush();
    }

    public abstract void write(EntityType var1, JsonGenerator var2) throws IOException;

    protected void writeEntityField(String fieldName, Object entity, JsonGenerator jg) throws IOException {
        jg.writeFieldName(fieldName);
        this.writeEntity(entity, jg);
    }

    protected void writeEntity(Object entity, JsonGenerator jg) throws IOException {
        this.writeEntity(entity, new OutputStreamWithJsonWriter(jg));
    }

    protected <ObjectType> void writeEntity(ObjectType entity, OutputStream out) throws IOException {
        Class<?> clazz = entity.getClass();
        Writer<?> writer = this.registry.getWriter(this.ctx, clazz, MediaType.APPLICATION_JSON_TYPE);
        if (writer == null) {
            throw new MarshallingException("Unable to get a writer for Java type " + entity.getClass() + " and mimetype " + MediaType.APPLICATION_JSON_TYPE);
        }
        writer.write(entity, entity.getClass(), entity.getClass(), MediaType.APPLICATION_JSON_TYPE, out);
    }

    protected JsonGenerator getGenerator(OutputStream out, boolean getCurrentIfAvailable) throws IOException {
        if (getCurrentIfAvailable && out instanceof OutputStreamWithJsonWriter) {
            OutputStreamWithJsonWriter casted = (OutputStreamWithJsonWriter)out;
            return casted.getJsonGenerator();
        }
        return JsonFactoryProvider.get().createGenerator(out);
    }

    protected <T extends Serializable> void writeSerializableListField(String fieldName, Collection<T> serializables, JsonGenerator jg) throws IOException {
        jg.writeArrayFieldStart(fieldName);
        for (Serializable serializable : serializables) {
            this.writeSerializable(serializable, jg);
        }
        jg.writeEndArray();
    }

    protected <T extends Serializable> void writeSerializableMapField(String fieldName, Map<String, T> map, JsonGenerator jg) throws IOException {
        jg.writeObjectFieldStart(fieldName);
        for (Map.Entry<String, T> entry : map.entrySet()) {
            this.writeSerializableField(entry.getKey(), (Serializable)entry.getValue(), jg);
        }
        jg.writeEndObject();
    }

    protected void writeSerializableField(String fieldName, Serializable value, JsonGenerator jg) throws IOException {
        jg.writeFieldName(fieldName);
        this.writeSerializable(value, jg);
    }

    protected void writeSerializable(Serializable value, JsonGenerator jg) throws IOException {
        if (value instanceof Collection) {
            jg.writeStartArray();
            for (Serializable serializable : (Collection)((Object)value)) {
                this.writeSerializable(serializable, jg);
            }
            jg.writeEndArray();
        } else if (value instanceof Serializable[]) {
            jg.writeStartArray();
            for (Serializable serializable : (Serializable[])value) {
                this.writeSerializable(serializable, jg);
            }
            jg.writeEndArray();
        } else if (value instanceof String) {
            jg.writeString((String)((Object)value));
        } else if (value instanceof Boolean) {
            jg.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Number) {
            jg.writeNumber(value.toString());
        } else {
            this.writeEntity(value, jg);
        }
    }
}

