/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfigurationService;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.IdentityQueryTransformer;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Predicates;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.localconfiguration.DirectoryConfiguration;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.UserMultiTenantManagement;
import org.nuxeo.runtime.api.Framework;

public class DefaultUserMultiTenantManagement
implements UserMultiTenantManagement {
    protected static final Log log = LogFactory.getLog(DefaultUserMultiTenantManagement.class);
    protected static final String SUFFIX_SEPARATOR = "-";

    protected String getDirectorySuffix(DocumentModel documentContext) {
        LocalConfigurationService localConfigurationService = (LocalConfigurationService)Framework.getService(LocalConfigurationService.class);
        DirectoryConfiguration configuration = (DirectoryConfiguration)localConfigurationService.getConfiguration(DirectoryConfiguration.class, "DirectoryLocalConfiguration", documentContext);
        if (configuration != null && configuration.getDirectorySuffix() != null) {
            return SUFFIX_SEPARATOR + configuration.getDirectorySuffix();
        }
        return null;
    }

    @Override
    public void queryTransformer(UserManager um, Map<String, Serializable> filter, Set<String> fulltext, DocumentModel context) {
        String groupId = um.getGroupIdField();
        if (filter == null || fulltext == null) {
            throw new NuxeoException("Filter and Fulltext must be not null");
        }
        if (this.getDirectorySuffix(context) == null) {
            log.debug((Object)"Directory Local Configuration is null, don't need to filter");
            return;
        }
        String groupIdSuffix = this.getDirectorySuffix(context);
        if (!filter.containsKey(groupId)) {
            log.debug((Object)("no filter on group id, need to filter with the directory local configuration suffix : " + groupId + " = %" + groupIdSuffix));
            filter.put(groupId, (Serializable)((Object)("%" + groupIdSuffix)));
            fulltext.add(groupId);
            return;
        }
        if (!(filter.get(groupId) instanceof String)) {
            throw new UnsupportedOperationException("Filter value on group id is not a string : " + filter.get(groupId));
        }
        String filterIdValue = (String)((Object)filter.get(um.getGroupIdField()));
        filter.put(groupId, (Serializable)((Object)(filterIdValue + groupIdSuffix)));
    }

    @Override
    public QueryBuilder groupQueryTransformer(UserManager um, QueryBuilder queryBuilder, DocumentModel context) {
        String groupIdField;
        String suffix = this.getDirectorySuffix(context);
        if (suffix == null) {
            log.debug((Object)"No tenant configuration");
            return queryBuilder;
        }
        MultiExpression multiExpr = (queryBuilder = new QueryBuilder(queryBuilder)).predicate();
        if (BaseSession.FieldDetector.hasField((MultiExpression)multiExpr, (String)(groupIdField = um.getGroupIdField()))) {
            QueryTenantAdder qta = new QueryTenantAdder(groupIdField, suffix);
            multiExpr = qta.transform(multiExpr);
        }
        Predicate predicate = Predicates.like((String)groupIdField, (Object)("%" + suffix));
        queryBuilder.predicate(predicate).and((Predicate)multiExpr);
        return queryBuilder;
    }

    @Override
    public DocumentModel groupTransformer(UserManager um, DocumentModel group, DocumentModel context) {
        if (context == null) {
            return group;
        }
        String groupIdValue = group.getPropertyValue(um.getGroupIdField()) + this.getDirectorySuffix(context);
        group.setPropertyValue(um.getGroupIdField(), (Serializable)((Object)groupIdValue));
        return group;
    }

    @Override
    public String groupnameTranformer(UserManager um, String groupname, DocumentModel context) {
        String suffix = this.getDirectorySuffix(context);
        if (suffix != null) {
            groupname = (String)groupname + suffix;
        }
        return groupname;
    }

    public static class QueryTenantAdder
    extends IdentityQueryTransformer {
        protected final String groupIdField;
        protected final String suffix;
        protected boolean isGroupPredicate;

        public QueryTenantAdder(String groupIdField, String suffix) {
            this.groupIdField = groupIdField;
            this.suffix = suffix;
        }

        public Expression transform(Expression node) {
            if (node.lvalue instanceof Reference && ((Reference)node.lvalue).name.equals(this.groupIdField) && (node.operator == Operator.EQ || node.operator == Operator.NOTEQ || node.operator == Operator.IN || node.operator == Operator.NOTIN)) {
                this.isGroupPredicate = true;
                node = super.transform(node);
                this.isGroupPredicate = false;
                return node;
            }
            return super.transform(node);
        }

        public Predicate transform(Predicate node) {
            if (node.lvalue instanceof Reference && ((Reference)node.lvalue).name.equals(this.groupIdField) && (node.operator == Operator.EQ || node.operator == Operator.NOTEQ || node.operator == Operator.IN || node.operator == Operator.NOTIN)) {
                this.isGroupPredicate = true;
                node = super.transform(node);
                this.isGroupPredicate = false;
                return node;
            }
            return super.transform(node);
        }

        public Literal transform(StringLiteral node) {
            if (!this.isGroupPredicate) {
                return node;
            }
            return new StringLiteral(node.value + this.suffix);
        }

        public Reference transform(Reference node) {
            if (this.isGroupPredicate) {
                return node;
            }
            if (node.name.equals(this.groupIdField)) {
                throw new QueryParseException("Cannot evaluate expression in multi-tenant mode");
            }
            return node;
        }
    }
}

