/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.platform.usermanager.GroupConfig;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.UserManagerDescriptor;
import org.nuxeo.ecm.platform.usermanager.VirtualUser;
import org.nuxeo.ecm.platform.usermanager.VirtualUserDescriptor;
import org.nuxeo.runtime.services.event.Event;

public class FakeUserManagerImpl
implements UserManager {
    private static final long serialVersionUID = 1L;
    String userListingMode;
    String groupListingMode;
    List<String> defaultAdministratorIds;
    List<String> administratorsGroups;
    String defaultGroup;
    String userSortField;
    String groupSortField;
    String userDirectoryName;
    String userEmailField;
    Map<String, UserManager.MatchType> userSearchFields;
    Pattern userPasswordPattern;
    String groupDirectoryName;
    String groupMembersField;
    Map<String, UserManager.MatchType> groupSearchFields;
    String groupSubGroupsField;
    String groupParentGroupsField;
    VirtualUser anonymousUser;
    final Map<String, VirtualUserDescriptor> virtualUsers = new HashMap<String, VirtualUserDescriptor>();

    public String getUserListingMode() {
        return this.userListingMode;
    }

    public void setUserListingMode(String userListingMode) {
        this.userListingMode = userListingMode;
    }

    public String getGroupListingMode() {
        return this.groupListingMode;
    }

    public void setGroupListingMode(String groupListingMode) {
        this.groupListingMode = groupListingMode;
    }

    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    public void setDefaultGroup(String defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    public String getUserSortField() {
        return this.userSortField;
    }

    public void setUserSortField(String sortField) {
        this.userSortField = sortField;
    }

    public void setGroupSortField(String sortField) {
        this.groupSortField = sortField;
    }

    public void setUserDirectoryName(String userDirectoryName) {
        this.userDirectoryName = userDirectoryName;
    }

    public String getUserDirectoryName() {
        return this.userDirectoryName;
    }

    public void setUserEmailField(String userEmailField) {
        this.userEmailField = userEmailField;
    }

    public String getUserEmailField() {
        return this.userEmailField;
    }

    public void setUserSearchFields(Set<String> userSearchFields) {
        this.userSearchFields = new LinkedHashMap<String, UserManager.MatchType>();
        for (String searchField : userSearchFields) {
            this.userSearchFields.put(searchField, UserManager.MatchType.SUBSTRING);
        }
    }

    public void setUserSearchFields(Map<String, UserManager.MatchType> userSearchFields) {
        this.userSearchFields = userSearchFields;
    }

    public Set<String> getUserSearchFields() {
        return this.userSearchFields.keySet();
    }

    public void setGroupSearchFields(Map<String, UserManager.MatchType> groupSearchFields) {
        this.groupSearchFields = groupSearchFields;
    }

    public Set<String> getGroupSearchFields() {
        return this.groupSearchFields.keySet();
    }

    public void setGroupDirectoryName(String groupDirectoryName) {
        this.groupDirectoryName = groupDirectoryName;
    }

    public String getGroupDirectoryName() {
        return this.groupDirectoryName;
    }

    public void setGroupMembersField(String groupMembersField) {
        this.groupMembersField = groupMembersField;
    }

    public String getGroupMembersField() {
        return this.groupMembersField;
    }

    public void setGroupSubGroupsField(String groupSubGroupsField) {
        this.groupSubGroupsField = groupSubGroupsField;
    }

    public String getGroupSubGroupsField() {
        return this.groupSubGroupsField;
    }

    public void setGroupParentGroupsField(String groupParentGroupsField) {
        this.groupParentGroupsField = groupParentGroupsField;
    }

    public String getGroupParentGroupsField() {
        return this.groupParentGroupsField;
    }

    public Boolean areGroupsReadOnly() {
        throw new UnsupportedOperationException();
    }

    public Boolean areUsersReadOnly() {
        throw new UnsupportedOperationException();
    }

    public boolean checkUsernamePassword(String username, String password) {
        return username.equals(password);
    }

    public boolean validatePassword(String password) {
        if (this.userPasswordPattern == null) {
            return true;
        }
        Matcher userPasswordMatcher = this.userPasswordPattern.matcher(password);
        return userPasswordMatcher.find();
    }

    public List<String> getGroupsInGroup(String parentId) {
        throw new UnsupportedOperationException();
    }

    public NuxeoPrincipal getPrincipal(String username, boolean fetchReferences) {
        NuxeoPrincipalImpl principal = new NuxeoPrincipalImpl("Administrator", false, true);
        if (fetchReferences) {
            principal.setGroups(Collections.singletonList("administrators"));
        }
        principal.setEmail("admin@example.com");
        return principal;
    }

    public List<String> getTopLevelGroups() {
        throw new UnsupportedOperationException();
    }

    public List<String> getUsersInGroup(String groupId) {
        throw new UnsupportedOperationException();
    }

    public List<String> getUsersInGroupAndSubGroups(String groupId) {
        throw new UnsupportedOperationException();
    }

    public DocumentModelList searchGroups(String pattern) {
        throw new UnsupportedOperationException();
    }

    public List<NuxeoPrincipal> searchPrincipals(String pattern) {
        throw new UnsupportedOperationException();
    }

    public Pattern getUserPasswordPattern() {
        return this.userPasswordPattern;
    }

    public void setUserPasswordPattern(Pattern userPasswordPattern) {
        this.userPasswordPattern = userPasswordPattern;
    }

    public void setAnonymousUser(VirtualUser anonymousUser) {
        this.anonymousUser = anonymousUser;
    }

    public void setVirtualUsers(Map<String, VirtualUserDescriptor> virtualUsers) {
        this.virtualUsers.clear();
        if (virtualUsers != null) {
            this.virtualUsers.putAll(virtualUsers);
        }
    }

    public String getAnonymousUserId() {
        if (this.anonymousUser == null) {
            return null;
        }
        return this.anonymousUser.getId();
    }

    public String getDigestAuthDirectory() {
        return null;
    }

    public String getDigestAuthRealm() {
        return null;
    }

    public void setConfiguration(UserManagerDescriptor descriptor) {
        this.setDefaultGroup(descriptor.defaultGroup);
        this.defaultAdministratorIds = descriptor.defaultAdministratorIds;
        this.administratorsGroups = descriptor.administratorsGroups;
        this.setUserSortField(descriptor.userSortField);
        this.setGroupSortField(descriptor.groupSortField);
        this.setUserListingMode(descriptor.userListingMode);
        this.setGroupListingMode(descriptor.groupListingMode);
        this.setUserDirectoryName(descriptor.userDirectoryName);
        this.setUserEmailField(descriptor.userEmailField);
        this.setUserSearchFields(descriptor.userSearchFields);
        this.setUserPasswordPattern(descriptor.userPasswordPattern);
        this.setGroupDirectoryName(descriptor.groupDirectoryName);
        this.setGroupMembersField(descriptor.groupMembersField);
        this.setGroupSubGroupsField(descriptor.groupSubGroupsField);
        this.setGroupParentGroupsField(descriptor.groupParentGroupsField);
        this.setGroupSearchFields(descriptor.groupSearchFields);
        this.setAnonymousUser((VirtualUser)descriptor.anonymousUser);
        this.setVirtualUsers(descriptor.virtualUsers);
    }

    public DocumentModel getBareUserModel() {
        throw new UnsupportedOperationException();
    }

    public DocumentModel createGroup(DocumentModel groupModel) {
        throw new UnsupportedOperationException();
    }

    public DocumentModel createUser(DocumentModel userModel) {
        throw new UnsupportedOperationException();
    }

    public void deleteGroup(DocumentModel groupModel) {
        throw new UnsupportedOperationException();
    }

    public void deleteGroup(String groupId) {
        throw new UnsupportedOperationException();
    }

    public void deleteUser(DocumentModel userModel) {
        throw new UnsupportedOperationException();
    }

    public void deleteUser(String userId) {
        throw new UnsupportedOperationException();
    }

    public DocumentModel getBareGroupModel() {
        throw new UnsupportedOperationException();
    }

    public NuxeoGroup getGroup(String groupName) {
        throw new UnsupportedOperationException();
    }

    public List<String> getGroupIds() {
        throw new UnsupportedOperationException();
    }

    public List<String> getUserIds() {
        throw new UnsupportedOperationException();
    }

    public DocumentModelList searchGroups(Map<String, Serializable> filter, Set<String> fulltext) {
        throw new UnsupportedOperationException();
    }

    public DocumentModelList searchGroups(QueryBuilder queryBuilder) {
        throw new UnsupportedOperationException();
    }

    public DocumentModelList searchUsers(Map<String, Serializable> filter, Set<String> fulltext) {
        throw new UnsupportedOperationException();
    }

    public DocumentModelList searchUsers(String pattern) {
        throw new UnsupportedOperationException();
    }

    public DocumentModelList searchUsers(QueryBuilder queryBuilder) {
        throw new UnsupportedOperationException();
    }

    public void updateGroup(DocumentModel groupModel) {
        throw new UnsupportedOperationException();
    }

    public void updateUser(DocumentModel userModel) {
        throw new UnsupportedOperationException();
    }

    public DocumentModel getGroupModel(String groupName) {
        throw new UnsupportedOperationException();
    }

    public DocumentModel getUserModel(String userName) {
        throw new UnsupportedOperationException();
    }

    public String getGroupIdField() {
        return "groupname";
    }

    public String getGroupLabelField() {
        return "grouplabel";
    }

    public String getGroupSchemaName() {
        return "group";
    }

    public String getUserIdField() {
        return "username";
    }

    public String getUserSchemaName() {
        return "user";
    }

    public List<String> getAdministratorsGroups() {
        throw new UnsupportedOperationException();
    }

    public String[] getUsersForPermission(String perm, ACP acp) {
        throw new UnsupportedOperationException();
    }

    public Principal authenticate(String name, String password) {
        return this.checkUsernamePassword(name, password) ? this.getPrincipal(name) : null;
    }

    public void handleEvent(Event event) {
    }

    public List<String> getAncestorGroups(String groupId) {
        throw new UnsupportedOperationException();
    }

    public GroupConfig getGroupConfig() {
        throw new UnsupportedOperationException();
    }

    public void notifyUserChanged(String userName, String eventId) {
        throw new UnsupportedOperationException();
    }

    public void notifyGroupChanged(String groupName, String eventId, List<String> ancestorGroupNames) {
        throw new UnsupportedOperationException();
    }
}

