/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.listener;

import java.io.Serializable;
import java.util.HashSet;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.runtime.api.Framework;

public class DocumentRoutingWorkflowInstancesCleanup
implements PostCommitEventListener {
    public static final String CLEANUP_WORKFLOW_INSTANCES_PROPERTY = "nuxeo.routing.disable.cleanup.workflow.instances";
    public static final String CLEANUP_WORKFLOW_INSTANCES_BATCH_SIZE_PROPERTY = "nuxeo.routing.cleanup.workflow.instances.batch.size";
    public static final String CLEANUP_WORKFLOW_REPO_NAME_PROPERTY = "repositoryName";
    public static final String CLEANUP_WORKFLOW_EVENT_NAME = "workflowInstancesCleanup";

    public void handleEvent(EventBundle events) {
        if (Framework.isBooleanPropertyTrue((String)CLEANUP_WORKFLOW_INSTANCES_PROPERTY)) {
            return;
        }
        int batchSize = Integer.parseInt(Framework.getProperty((String)CLEANUP_WORKFLOW_INSTANCES_BATCH_SIZE_PROPERTY, (String)"100"));
        DocumentRoutingService routing = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        HashSet<String> repositoryNames = new HashSet<String>();
        for (Event event : events) {
            if (event.getContext().hasProperty(CLEANUP_WORKFLOW_REPO_NAME_PROPERTY)) {
                String repositoryName = (String)((Object)event.getContext().getProperty(CLEANUP_WORKFLOW_REPO_NAME_PROPERTY));
                repositoryNames.add(repositoryName);
                continue;
            }
            repositoryNames.addAll(repositoryManager.getRepositoryNames());
        }
        for (String repositoryName : repositoryNames) {
            this.doCleanAndReschedule(batchSize, routing, repositoryName);
        }
    }

    private void doCleanAndReschedule(int batchSize, DocumentRoutingService routing, String repositoryName) {
        int cleanedUpWf = routing.doCleanupDoneAndCanceledRouteInstances(repositoryName, batchSize);
        if (cleanedUpWf == batchSize) {
            EventContextImpl eCtx = new EventContextImpl(new Object[0]);
            eCtx.setProperty(CLEANUP_WORKFLOW_REPO_NAME_PROPERTY, (Serializable)((Object)repositoryName));
            Event event = eCtx.newEvent(CLEANUP_WORKFLOW_EVENT_NAME);
            EventProducer eventProducer = (EventProducer)Framework.getService(EventProducer.class);
            eventProducer.fireEvent(event);
        }
    }
}

