/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.directory.server.core.partition.impl.btree.IndexAssertion;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexAssertionEnumeration
implements NamingEnumeration<IndexRecord> {
    private final IndexRecord prefetched = new IndexRecord();
    private final IndexRecord candidate = new IndexRecord();
    private final NamingEnumeration<IndexRecord> underlying;
    private final Map<Object, Object> candidates;
    private final IndexAssertion assertion;
    private final boolean checkDups;
    private boolean hasMore = true;

    public IndexAssertionEnumeration(NamingEnumeration<IndexRecord> underlying, IndexAssertion assertion) throws NamingException {
        this.underlying = underlying;
        this.candidates = null;
        this.assertion = assertion;
        this.checkDups = false;
        this.prefetch();
    }

    public IndexAssertionEnumeration(NamingEnumeration<IndexRecord> underlying, IndexAssertion assertion, boolean enableDupCheck) throws NamingException {
        this.underlying = underlying;
        this.candidates = new HashMap<Object, Object>();
        this.assertion = assertion;
        this.checkDups = enableDupCheck;
        this.prefetch();
    }

    @Override
    public IndexRecord nextElement() {
        try {
            return this.next();
        }
        catch (NamingException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMore;
    }

    @Override
    public IndexRecord next() throws NamingException {
        this.candidate.copy(this.prefetched);
        this.prefetch();
        return this.candidate;
    }

    @Override
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public void close() throws NamingException {
        this.hasMore = false;
        this.underlying.close();
    }

    private void prefetch() throws NamingException {
        IndexRecord rec = null;
        while (this.underlying.hasMore()) {
            rec = this.underlying.next();
            if (!this.assertion.assertCandidate(rec)) continue;
            if (this.checkDups) {
                boolean dup = this.candidates.containsKey(rec.getEntryId());
                if (dup) continue;
                this.prefetched.copy(rec);
                this.candidates.put(rec.getEntryId(), rec.getEntryId());
                return;
            }
            this.prefetched.copy(rec);
            return;
        }
        this.close();
    }
}

