/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.codec.NoCodec;
import org.nuxeo.lib.stream.computation.ComputationPolicy;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.RecordFilter;
import org.nuxeo.lib.stream.computation.RecordFilterChain;
import org.nuxeo.lib.stream.computation.internals.RecordFilterChainImpl;

public class Settings {
    protected final int defaultPartitions;
    protected final Map<String, Integer> partitions = new HashMap<String, Integer>();
    protected final Codec<Record> defaultCodec;
    protected final Map<String, Codec<Record>> codecs = new HashMap<String, Codec<Record>>();
    protected final RecordFilterChain defaultFilter;
    protected final Map<String, RecordFilterChain> filters = new HashMap<String, RecordFilterChain>();
    protected final Map<String, Boolean> externals = new HashMap<String, Boolean>();
    protected final boolean defaultExternal;
    protected final int defaultConcurrency;
    protected final Map<String, Integer> concurrencies = new HashMap<String, Integer>();
    protected final ComputationPolicy defaultPolicy;
    protected final Map<String, ComputationPolicy> policies = new HashMap<String, ComputationPolicy>();

    public Settings(int defaultConcurrency, int defaultPartitions) {
        this(defaultConcurrency, defaultPartitions, null, null, null);
    }

    public Settings(int defaultConcurrency, int defaultPartitions, Codec<Record> defaultCodec) {
        this(defaultConcurrency, defaultPartitions, defaultCodec, null, null);
    }

    public Settings(int defaultConcurrency, int defaultPartitions, ComputationPolicy defaultPolicy) {
        this(defaultConcurrency, defaultPartitions, null, defaultPolicy, null);
    }

    public Settings(int defaultConcurrency, int defaultPartitions, Codec<Record> defaultCodec, ComputationPolicy defaultPolicy) {
        this(defaultConcurrency, defaultPartitions, defaultCodec, defaultPolicy, null);
    }

    public Settings(int defaultConcurrency, int defaultPartitions, Codec<Record> defaultCodec, ComputationPolicy defaultPolicy, RecordFilterChain defaultFilter) {
        this(defaultConcurrency, defaultPartitions, defaultCodec, defaultPolicy, defaultFilter, false);
    }

    public Settings(int defaultConcurrency, int defaultPartitions, Codec<Record> defaultCodec, ComputationPolicy defaultPolicy, RecordFilterChain defaultFilter, boolean defaultExternal) {
        this.defaultConcurrency = defaultConcurrency;
        this.defaultPartitions = defaultPartitions;
        this.defaultCodec = defaultCodec == null ? NoCodec.NO_CODEC : defaultCodec;
        this.defaultPolicy = defaultPolicy == null ? ComputationPolicy.NONE : defaultPolicy;
        this.defaultFilter = defaultFilter == null ? RecordFilterChainImpl.NONE : defaultFilter;
        this.defaultExternal = defaultExternal;
    }

    public Settings setConcurrency(String computationName, int concurrency) {
        this.concurrencies.put(computationName, concurrency);
        return this;
    }

    public int getConcurrency(String computationName) {
        return this.concurrencies.getOrDefault(computationName, this.defaultConcurrency);
    }

    public Settings setPartitions(String streamName, int partitions) {
        this.partitions.put(streamName, partitions);
        return this;
    }

    public int getPartitions(String streamName) {
        return this.partitions.getOrDefault(streamName, this.defaultPartitions);
    }

    public Settings setExternal(String streamName, boolean external) {
        this.externals.put(streamName, external);
        return this;
    }

    public boolean isExternal(String streamName) {
        return this.externals.getOrDefault(streamName, this.defaultExternal);
    }

    public Settings setCodec(String streamName, Codec<Record> codec) {
        Objects.requireNonNull(codec);
        this.codecs.put(streamName, codec);
        return this;
    }

    public Codec<Record> getCodec(String streamName) {
        return this.codecs.getOrDefault(streamName, this.defaultCodec);
    }

    public Settings setPolicy(String computationName, ComputationPolicy policy) {
        if (policy == null) {
            this.policies.remove(computationName);
        } else {
            this.policies.put(computationName, policy);
        }
        return this;
    }

    public ComputationPolicy getPolicy(String computationName) {
        return this.policies.getOrDefault(computationName, this.defaultPolicy);
    }

    public Settings addFilter(String streamName, RecordFilter filter) {
        if (filter == null) {
            this.filters.remove(streamName);
        } else {
            RecordFilterChain chain = this.filters.computeIfAbsent(streamName, k -> new RecordFilterChainImpl());
            chain.addFilter(filter);
        }
        return this;
    }

    public RecordFilterChain getFilterChain(String streamName) {
        return this.filters.getOrDefault(streamName, this.defaultFilter);
    }
}

