/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.csv.export.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.csv.CSVPrinter;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.csv.AbstractCSVWriter;
import org.nuxeo.ecm.core.io.marshallers.csv.OutputStreamWithCSVWriter;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.csv.export.io.DocumentModelCSVHelper;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DocumentModelListCSVWriter
extends AbstractCSVWriter<List<DocumentModel>> {
    protected void write(List<DocumentModel> entity, CSVPrinter printer) throws IOException {
        Writer writer = this.registry.getWriter(this.ctx, DocumentModel.class, TEXT_CSV_TYPE);
        for (DocumentModel doc : entity) {
            try (OutputStreamWithCSVWriter out = new OutputStreamWithCSVWriter(printer);){
                writer.write((Object)doc, DocumentModel.class, DocumentModel.class, TEXT_CSV_TYPE, (OutputStream)out);
            }
            printer.println();
        }
    }

    protected void writeHeader(List<DocumentModel> entity, CSVPrinter printer) throws IOException {
        DocumentModelCSVHelper.printSystemPropertiesHeader(printer);
        List<String> schemas = DocumentModelCSVHelper.getList(this.ctx, "schemas");
        List<String> xpaths = DocumentModelCSVHelper.getList(this.ctx, "xpaths");
        DocumentModelCSVHelper.printPropertiesHeader(schemas, xpaths, printer);
        printer.println();
    }
}

