/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.comment.api.Comment;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.comment.api.exceptions.CommentNotFoundException;
import org.nuxeo.ecm.platform.comment.api.exceptions.CommentSecurityException;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractCommentManager
implements CommentManager {
    private static final Logger log = LogManager.getLogger(AbstractCommentManager.class);
    protected static final String COMMENTS_DIRECTORY = "Comments";

    public List<DocumentModel> getComments(DocumentModel docModel) {
        return this.getComments(docModel.getCoreSession(), docModel);
    }

    public List<DocumentModel> getComments(DocumentModel docModel, DocumentModel parent) {
        return this.getComments(docModel);
    }

    public List<Comment> getComments(CoreSession session, String documentId) {
        return this.getComments(session, documentId, 0L, 0L, true);
    }

    public List<Comment> getComments(CoreSession session, String documentId, boolean sortAscending) {
        return this.getComments(session, documentId, 0L, 0L, sortAscending);
    }

    public PartialList<Comment> getComments(CoreSession session, String documentId, Long pageSize, Long currentPageIndex) {
        return this.getComments(session, documentId, pageSize, currentPageIndex, true);
    }

    public DocumentRef getTopLevelDocumentRef(CoreSession session, DocumentRef commentRef) {
        NuxeoPrincipal principal = session.getPrincipal();
        return (DocumentRef)CoreInstance.doPrivileged((CoreSession)session, s -> {
            if (!s.exists(commentRef)) {
                throw new CommentNotFoundException(String.format("The comment %s does not exist.", commentRef));
            }
            DocumentModel commentDoc = s.getDocument(commentRef);
            DocumentModel topLevelDoc = this.getTopLevelDocument((CoreSession)s, commentDoc);
            DocumentRef topLevelDocRef = topLevelDoc.getRef();
            if (!s.hasPermission(principal, topLevelDocRef, "Read")) {
                throw new CommentSecurityException("The user " + principal.getName() + " does not have access to the comments of document " + topLevelDocRef);
            }
            return topLevelDocRef;
        });
    }

    protected void notifyEvent(CoreSession session, String eventType, DocumentModel commentDoc) {
        DocumentModel commentedDoc = this.getCommentedDocument(session, commentDoc);
        this.notifyEvent(session, eventType, commentedDoc, commentDoc);
    }

    protected void notifyEvent(CoreSession session, String eventType, DocumentModel commentedDoc, DocumentModel commentDoc) {
        DocumentModel topLevelDoc = this.getTopLevelDocument(session, commentDoc);
        this.notifyEvent(session, eventType, topLevelDoc, commentedDoc, commentDoc);
    }

    protected void notifyEvent(CoreSession session, String eventType, DocumentModel topLevelDoc, DocumentModel commentedDoc, DocumentModel commentDoc) {
        Objects.requireNonNull(eventType);
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        NuxeoPrincipal principal = null;
        if (userManager != null && (principal = userManager.getPrincipal((String)((Object)commentDoc.getPropertyValue("comment:author")))) == null) {
            try {
                principal = this.getAuthor(commentDoc);
            }
            catch (PropertyException e) {
                log.error("Error building principal for comment author", (Throwable)e);
                return;
            }
        }
        DocumentEventContext ctx = new DocumentEventContext(session, principal, commentedDoc);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("topLevelDocument", topLevelDoc);
        props.put("parentComment", commentedDoc);
        if (!topLevelDoc.equals(commentedDoc)) {
            String commentAuthor;
            NuxeoPrincipal commentPrincipal = this.getAuthor(commentedDoc);
            commentAuthor = commentPrincipal != null ? (StringUtils.isBlank((CharSequence)(commentAuthor = commentPrincipal.getFirstName())) ? commentPrincipal.getName() : commentAuthor) : ((String[])commentedDoc.getPropertyValue("dc:contributors"))[0];
            props.put("parentCommentAuthor", commentAuthor);
        }
        props.put("comment_document", commentDoc);
        props.put("comment", commentDoc.getPropertyValue("comment:text"));
        props.put("comment_text", commentDoc.getPropertyValue("comment:text"));
        props.put("category", "commentCategory");
        ctx.setProperties(props);
        Event event = ctx.newEvent(eventType);
        EventProducer evtProducer = (EventProducer)Framework.getService(EventProducer.class);
        evtProducer.fireEvent(event);
    }

    protected abstract DocumentModel getTopLevelDocument(CoreSession var1, DocumentModel var2);

    protected abstract DocumentModel getCommentedDocument(CoreSession var1, DocumentModel var2);

    protected NuxeoPrincipal getAuthor(DocumentModel docModel) {
        NuxeoPrincipal principal;
        String author = null;
        if (docModel.hasSchema("comment")) {
            author = (String)((Object)docModel.getPropertyValue("comment:author"));
        }
        if (StringUtils.isBlank(author)) {
            String[] contributors = (String[])docModel.getPropertyValue("dc:contributors");
            author = contributors[0];
        }
        if ((principal = ((UserManager)Framework.getService(UserManager.class)).getPrincipal(author)) == null) {
            log.debug("Principal not found: {}", (Object)author);
        }
        return principal;
    }

    protected void setFolderPermissions(CoreSession session, DocumentModel documentModel) {
        ACP acp = documentModel.getACP();
        acp.blockInheritance("local", "system");
        documentModel.setACP(acp, true);
    }

    @Deprecated(since="11.1")
    protected void setCommentPermissions(CoreSession session, DocumentModel documentModel) {
        ACPImpl acp = new ACPImpl();
        ACE grantRead = new ACE("Everyone", "Read", true);
        ACE grantRemove = new ACE("members", "Remove", true);
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{grantRead, grantRemove});
        acp.addACL((ACL)acl);
        session.setACP(documentModel.getRef(), (ACP)acp, true);
    }

    protected <S extends Set<String> & Serializable> S computeAncestorIds(CoreSession session, String parentId) {
        HashSet<String> ancestorIds = new HashSet<String>();
        ancestorIds.add(parentId);
        IdRef parentRef = new IdRef(parentId);
        while (session.exists((DocumentRef)parentRef) && session.getDocument((DocumentRef)parentRef).hasSchema("comment")) {
            parentId = (String)((Object)session.getDocument((DocumentRef)parentRef).getPropertyValue("comment:parentId"));
            ancestorIds.add(parentId);
            parentRef = new IdRef(parentId);
        }
        return (S)ancestorIds;
    }
}

