/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.annotations.MapKey;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.comment.UIAuditComment;
import org.nuxeo.ecm.platform.audit.impl.ExtendedInfoImpl;
import org.nuxeo.ecm.platform.audit.io.ExtendedInfoDeserializer;
import org.nuxeo.ecm.platform.audit.io.ExtendedInfoSerializer;

@Entity(name="LogEntry")
@NamedQueries(value={@NamedQuery(name="LogEntry.removeByEventIdAndPath", query="delete LogEntry log where log.eventId = :eventId and log.docPath like :pathPattern"), @NamedQuery(name="LogEntry.findByDocument", query="from LogEntry log where log.docUUID=:docUUID ORDER BY log.eventDate DESC"), @NamedQuery(name="LogEntry.findByDocumentAndRepository", query="from LogEntry log where log.docUUID=:docUUID and log.repositoryId=:repositoryId ORDER BY log.eventDate DESC"), @NamedQuery(name="LogEntry.findAll", query="from LogEntry log order by log.eventDate DESC"), @NamedQuery(name="LogEntry.findByEventIdAndPath", query="from LogEntry log where log.eventId=:eventId and log.docPath LIKE :pathPattern"), @NamedQuery(name="LogEntry.findByHavingExtendedInfo", query="from LogEntry log where log.extendedInfos['one'] is not null order by log.eventDate DESC"), @NamedQuery(name="LogEntry.countEventsById", query="select count(log.eventId) from LogEntry log where log.eventId=:eventId"), @NamedQuery(name="LogEntry.findEventIds", query="select distinct log.eventId from LogEntry log")})
@Table(name="NXP_LOGS")
public class LogEntryImpl
implements LogEntry {
    @JsonProperty(value="entity-type")
    protected String entityType;
    private static final long serialVersionUID = 3037187381843636097L;
    private long id;
    private String principalName;
    private String eventId;
    private Date eventDate;
    private Date logDate;
    private String docUUID;
    private String docType;
    private String docPath;
    private String category;
    private String comment;
    private String docLifeCycle;
    private String repositoryId;
    protected transient UIAuditComment uiComment;
    private Map<String, ExtendedInfo> extendedInfos = new HashMap<String, ExtendedInfo>();

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="LOG_ID", nullable=false, columnDefinition="integer")
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Column(name="LOG_PRINCIPAL_NAME")
    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    @Column(name="LOG_EVENT_ID", nullable=false)
    @javax.persistence.MapKey(name="logKey")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @JsonSerialize(using=DateSerializer.class)
    @Column(name="LOG_EVENT_DATE")
    public Date getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @JsonSerialize(using=DateSerializer.class)
    @Column(name="LOG_DATE")
    public Date getLogDate() {
        return this.logDate;
    }

    public void setLogDate(Date logDate) {
        this.logDate = logDate;
    }

    @Column(name="LOG_DOC_UUID")
    public String getDocUUID() {
        return this.docUUID;
    }

    public void setDocUUID(String docUUID) {
        this.docUUID = docUUID;
    }

    public void setDocUUID(DocumentRef docRef) {
        switch (docRef.type()) {
            case 1: {
                this.docUUID = (String)docRef.reference();
                break;
            }
            case 3: {
                this.docUUID = ((DocumentModel)docRef.reference()).getId();
                break;
            }
            default: {
                throw new IllegalArgumentException("not an id reference " + docRef);
            }
        }
    }

    @Column(name="LOG_DOC_PATH", length=1024)
    public String getDocPath() {
        return this.docPath;
    }

    public void setDocPath(String docPath) {
        this.docPath = docPath;
    }

    @Column(name="LOG_DOC_TYPE")
    public String getDocType() {
        return this.docType;
    }

    public void setDocType(String docType) {
        this.docType = docType;
    }

    @Column(name="LOG_EVENT_CATEGORY")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Column(name="LOG_EVENT_COMMENT", length=1024)
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Column(name="LOG_DOC_LIFE_CYCLE")
    public String getDocLifeCycle() {
        return this.docLifeCycle;
    }

    public void setDocLifeCycle(String docLifeCycle) {
        this.docLifeCycle = docLifeCycle;
    }

    @Column(name="LOG_REPO_ID")
    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    @JsonProperty(value="extended")
    @JsonSerialize(keyAs=String.class, contentUsing=ExtendedInfoSerializer.class)
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=ExtendedInfoImpl.class)
    @JoinTable(name="NXP_LOGS_MAPEXTINFOS", joinColumns={@JoinColumn(name="LOG_FK")}, inverseJoinColumns={@JoinColumn(name="INFO_FK")})
    @MapKey(columns={@Column(name="mapkey", nullable=false)})
    public Map<String, ExtendedInfo> getExtendedInfos() {
        return this.extendedInfos;
    }

    @JsonDeserialize(keyAs=String.class, contentUsing=ExtendedInfoDeserializer.class)
    public void setExtendedInfos(Map<String, ExtendedInfo> infos) {
        this.extendedInfos = infos;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Transient
    public UIAuditComment getPreprocessedComment() {
        return this.uiComment;
    }

    public void setPreprocessedComment(UIAuditComment uiComment) {
        this.uiComment = uiComment;
    }

    static class DateSerializer
    extends JsonSerializer<Date> {
        public void serialize(Date date, JsonGenerator jg, SerializerProvider serializers) throws IOException {
            jg.writeObject((Object)date.toInstant().toString());
        }
    }
}

