/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.csv.CSVPrinter;
import org.nuxeo.ecm.core.io.marshallers.csv.AbstractCSVWriter;
import org.nuxeo.ecm.core.io.marshallers.csv.OutputStreamWithCSVWriter;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.io.LogEntryCSVWriter;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class LogEntryListCSVWriter
extends AbstractCSVWriter<List<LogEntry>> {
    protected void write(List<LogEntry> entity, CSVPrinter printer) throws IOException {
        Writer writer = this.registry.getWriter(this.ctx, LogEntry.class, TEXT_CSV_TYPE);
        for (LogEntry logEntry : entity) {
            try (OutputStreamWithCSVWriter out = new OutputStreamWithCSVWriter(printer);){
                writer.write((Object)logEntry, LogEntry.class, LogEntry.class, TEXT_CSV_TYPE, (OutputStream)out);
            }
            printer.println();
        }
    }

    protected void writeHeader(List<LogEntry> entity, CSVPrinter printer) throws IOException {
        LogEntryCSVWriter.writeHeader(printer, this.ctx);
    }
}

