/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.service;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.jboss.el.ExpressionFactoryImpl;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.event.DeletedDocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByExprs;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Predicates;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.platform.audit.api.AuditQueryBuilder;
import org.nuxeo.ecm.platform.audit.api.AuditStorage;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.FilterMapEntry;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.impl.LogEntryImpl;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.BaseLogEntryProvider;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.ecm.platform.audit.service.extension.AdapterDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.AuditBackendDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.ExtendedInfoDescriptor;
import org.nuxeo.ecm.platform.el.ExpressionContext;
import org.nuxeo.ecm.platform.el.ExpressionEvaluator;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamService;

public abstract class AbstractAuditBackend
implements AuditBackend,
AuditStorage {
    protected static final Logger log = LogManager.getLogger(AbstractAuditBackend.class);
    public static final String FORCE_AUDIT_FACET = "ForceAudit";
    protected final NXAuditEventsService component;
    protected final AuditBackendDescriptor config;
    protected final ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator((ExpressionFactory)new ExpressionFactoryImpl());

    protected AbstractAuditBackend(NXAuditEventsService component, AuditBackendDescriptor config) {
        this.component = component;
        this.config = config;
    }

    protected AbstractAuditBackend() {
        this(null, null);
    }

    protected DocumentModel guardedDocument(CoreSession session, DocumentRef reference) {
        if (session == null) {
            return null;
        }
        if (reference == null) {
            return null;
        }
        try {
            return session.getDocument(reference);
        }
        catch (DocumentNotFoundException e) {
            return null;
        }
    }

    protected DocumentModelList guardedDocumentChildren(CoreSession session, DocumentRef reference) {
        return session.getChildren(reference);
    }

    protected LogEntry doCreateAndFillEntryFromDocument(DocumentModel doc, Principal principal) {
        LogEntry entry = this.newLogEntry();
        entry.setDocPath(doc.getPathAsString());
        entry.setDocType(doc.getType());
        entry.setDocUUID(doc.getId());
        entry.setRepositoryId(doc.getRepositoryName());
        entry.setPrincipalName("system");
        entry.setCategory("eventDocumentCategory");
        entry.setEventId("documentCreated");
        entry.setDocLifeCycle("project");
        Calendar creationDate = (Calendar)doc.getProperty("dublincore", "created");
        if (creationDate != null) {
            entry.setEventDate(creationDate.getTime());
        }
        this.doPutExtendedInfos(entry, null, doc, principal);
        return entry;
    }

    protected void doPutExtendedInfos(LogEntry entry, EventContext eventContext, DocumentModel source, Principal principal) {
        Map map;
        ExpressionContext context = new ExpressionContext();
        if (eventContext != null) {
            this.expressionEvaluator.bindValue((ELContext)context, "message", (Object)eventContext);
        }
        if (source != null) {
            this.expressionEvaluator.bindValue((ELContext)context, "source", (Object)source);
            for (AdapterDescriptor ad : this.component.getDocumentAdapters()) {
                Object adapter;
                if (source instanceof DeletedDocumentModel || (adapter = source.getAdapter(ad.getKlass())) == null) continue;
                this.expressionEvaluator.bindValue((ELContext)context, ad.getName(), adapter);
            }
        }
        if (principal != null) {
            this.expressionEvaluator.bindValue((ELContext)context, "principal", (Object)principal);
        }
        this.populateExtendedInfo(entry, source, context, this.component.getExtendedInfoDescriptors());
        this.populateExtendedInfo(entry, source, context, (Collection<ExtendedInfoDescriptor>)this.component.getEventExtendedInfoDescriptors().get(entry.getEventId()));
        if (eventContext != null && (map = (Map)((Object)eventContext.getProperty("extendedInfos"))) != null) {
            Map extendedInfos = entry.getExtendedInfos();
            for (Map.Entry en : map.entrySet()) {
                Serializable value = (Serializable)en.getValue();
                if (value == null) continue;
                extendedInfos.put((String)en.getKey(), this.newExtendedInfo(value));
            }
        }
    }

    protected void populateExtendedInfo(LogEntry entry, DocumentModel source, ExpressionContext context, Collection<ExtendedInfoDescriptor> extInfos) {
        if (extInfos != null) {
            Map extendedInfos = entry.getExtendedInfos();
            for (ExtendedInfoDescriptor descriptor : extInfos) {
                Serializable value;
                String exp = descriptor.getExpression();
                try {
                    value = (Serializable)this.expressionEvaluator.evaluateExpression((ELContext)context, exp, Serializable.class);
                }
                catch (UnsupportedOperationException | PropertyException e) {
                    if (!(source instanceof DeletedDocumentModel)) continue;
                    log.debug("Can not evaluate the expression: {} on a DeletedDocumentModel, skipping.", (Object)exp);
                    continue;
                }
                catch (DocumentNotFoundException e) {
                    if ("documentRemoved".equals(entry.getEventId())) continue;
                    log.error("Not found: {}, entry: {}", (Object)e.getMessage(), (Object)entry, (Object)e);
                    continue;
                }
                catch (ELException e) {
                    continue;
                }
                if (value == null) continue;
                extendedInfos.put(descriptor.getKey(), this.newExtendedInfo(value));
            }
        }
    }

    public Set<String> getAuditableEventNames() {
        return this.component.getAuditableEventNames();
    }

    public LogEntry buildEntryFromEvent(Event event) {
        EventContext ctx = event.getContext();
        String eventName = event.getName();
        Date eventDate = new Date(event.getTime());
        LogEntry entry = this.newLogEntry();
        entry.setEventId(eventName);
        entry.setEventDate(eventDate);
        if (ctx instanceof DocumentEventContext) {
            String category;
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel document = docCtx.getSourceDocument();
            if (document.hasFacet("SystemDocument") && !document.hasFacet(FORCE_AUDIT_FACET)) {
                return null;
            }
            Boolean disabled = (Boolean)docCtx.getProperty("disableAuditLogger");
            if (disabled != null && disabled.booleanValue()) {
                return null;
            }
            NuxeoPrincipal principal = docCtx.getPrincipal();
            Map properties = docCtx.getProperties();
            entry.setDocUUID(document.getId());
            entry.setDocPath(document.getPathAsString());
            entry.setDocType(document.getType());
            entry.setRepositoryId(document.getRepositoryName());
            if (principal != null) {
                entry.setPrincipalName(principal.getActingUser());
            } else {
                log.warn("received event {} with null principal", (Object)eventName);
            }
            entry.setComment((String)properties.get("comment"));
            if (document instanceof DeletedDocumentModel) {
                entry.setComment("Document does not exist anymore!");
            } else if (document.isLifeCycleLoaded()) {
                entry.setDocLifeCycle(document.getCurrentLifeCycleState());
            }
            if ("lifecycle_transition_event".equals(eventName)) {
                entry.setDocLifeCycle((String)((Object)docCtx.getProperty("to")));
            }
            if ((category = (String)properties.get("category")) != null) {
                entry.setCategory(category);
            } else {
                entry.setCategory("eventDocumentCategory");
            }
            this.doPutExtendedInfos(entry, (EventContext)docCtx, document, (Principal)principal);
        } else {
            NuxeoPrincipal principal = ctx.getPrincipal();
            Map properties = ctx.getProperties();
            if (principal != null) {
                entry.setPrincipalName(principal.getActingUser());
            }
            entry.setComment((String)properties.get("comment"));
            String category = (String)properties.get("category");
            entry.setCategory(category);
            this.doPutExtendedInfos(entry, ctx, null, (Principal)principal);
        }
        return entry;
    }

    public LogEntry newLogEntry() {
        return new LogEntryImpl();
    }

    public abstract ExtendedInfo newExtendedInfo(Serializable var1);

    protected long syncLogCreationEntries(BaseLogEntryProvider provider, String repoId, String path, Boolean recurs) {
        provider.removeEntries("documentCreated", path);
        CoreSession session = CoreInstance.getCoreSession((String)repoId);
        PathRef rootRef = new PathRef(path);
        DocumentModel root = this.guardedDocument(session, (DocumentRef)rootRef);
        long nbAddedEntries = this.doSyncNode(provider, session, root, recurs);
        log.debug("synced {}  entries on {}", (Object)nbAddedEntries, (Object)path);
        return nbAddedEntries;
    }

    protected long doSyncNode(BaseLogEntryProvider provider, CoreSession session, DocumentModel node, boolean recurs) {
        long nbSyncedEntries = 1L;
        NuxeoPrincipal principal = session.getPrincipal();
        ArrayList<DocumentModel> folderishChildren = new ArrayList<DocumentModel>();
        provider.addLogEntry(this.doCreateAndFillEntryFromDocument(node, (Principal)session.getPrincipal()));
        for (DocumentModel child : this.guardedDocumentChildren(session, node.getRef())) {
            if (child.isFolder() && recurs) {
                folderishChildren.add(child);
                continue;
            }
            provider.addLogEntry(this.doCreateAndFillEntryFromDocument(child, (Principal)principal));
            ++nbSyncedEntries;
        }
        if (recurs) {
            for (DocumentModel folderChild : folderishChildren) {
                nbSyncedEntries += this.doSyncNode(provider, session, folderChild, recurs);
            }
        }
        return nbSyncedEntries;
    }

    @Deprecated
    public void logEvents(EventBundle bundle) {
        if (!this.isAuditable(bundle)) {
            return;
        }
        for (Event event : bundle) {
            this.logEvent(event);
        }
    }

    protected boolean isAuditable(EventBundle eventBundle) {
        for (String name : this.getAuditableEventNames()) {
            if (!eventBundle.containsEventName(name)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public void logEvent(Event event) {
        if (!this.getAuditableEventNames().contains(event.getName())) {
            return;
        }
        LogEntry entry = this.buildEntryFromEvent(event);
        if (entry == null) {
            return;
        }
        if (Framework.isBooleanPropertyFalse((String)"nuxeo.stream.audit.enabled")) {
            this.component.bulker.offer(entry);
        } else {
            log.error("Usage of AuditLogger#logEvent while AuditBulker is disabled", (Throwable)new Exception());
        }
    }

    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        if (Framework.isBooleanPropertyFalse((String)"nuxeo.stream.audit.enabled")) {
            return this.component.bulker.await(time, unit);
        }
        StreamService service = (StreamService)Framework.getService(StreamService.class);
        org.nuxeo.lib.stream.log.LogManager logManager = service.getLogManager("audit");
        long deadline = System.currentTimeMillis() + unit.toMillis(time);
        while (logManager.getLag("audit", "AuditLogWriter").lag() > 0L) {
            if (System.currentTimeMillis() > deadline) {
                return false;
            }
            Thread.sleep(50L);
        }
        return true;
    }

    @Deprecated
    public List<LogEntry> getLogEntriesFor(String uuid, Map<String, FilterMapEntry> filterMap, boolean doDefaultSort) {
        AuditQueryBuilder builder = new AuditQueryBuilder();
        builder.predicate(Predicates.eq((String)"docUUID", (Object)uuid));
        filterMap.values().stream().map(this::convert).forEach(arg_0 -> ((QueryBuilder)builder).and(arg_0));
        if (doDefaultSort) {
            builder.defaultOrder();
        }
        return this.queryLogs((QueryBuilder)builder);
    }

    protected Predicate convert(FilterMapEntry entry) {
        String name = entry.getColumnName();
        String operator = entry.getOperator();
        Object value = entry.getObject();
        if (Operator.EQ.toString().equals(operator)) {
            return Predicates.eq((String)name, (Object)value);
        }
        if (Operator.LT.toString().equals(operator)) {
            return Predicates.lt((String)name, (Object)value);
        }
        if (Operator.LTEQ.toString().equals(operator)) {
            return Predicates.lte((String)name, (Object)value);
        }
        if (Operator.GTEQ.toString().equals(operator)) {
            return Predicates.gte((String)name, (Object)value);
        }
        if (Operator.GT.toString().equals(operator)) {
            return Predicates.gt((String)name, (Object)value);
        }
        if (Operator.IN.toString().equals(operator)) {
            return Predicates.in((String)name, (Iterable)((List)value));
        }
        throw new NuxeoException(String.format("Audit backend search doesn't handle '%s' operator", operator));
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, Date limit, String[] categories, String path, int pageNb, int pageSize) {
        AuditQueryBuilder builder = new AuditQueryBuilder();
        if (ArrayUtils.isNotEmpty((Object[])eventIds)) {
            if (eventIds.length == 1) {
                builder.predicate(Predicates.eq((String)"eventId", (Object)eventIds[0]));
            } else {
                builder.predicate(Predicates.in((String)"eventId", (Object)eventIds[0], (Object[])new String[0]));
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])categories)) {
            if (categories.length == 1) {
                builder.predicate(Predicates.eq((String)"category", (Object)categories[0]));
            } else {
                builder.predicate(Predicates.in((String)"category", (Object)categories[0], (Object[])new String[0]));
            }
        }
        if (path != null) {
            builder.predicate(Predicates.eq((String)"docPath", (Object)path));
        }
        if (limit != null) {
            builder.predicate(Predicates.lt((String)"eventDate", (Object)limit));
        }
        builder.offset((long)(pageNb * pageSize)).limit((long)pageSize);
        return this.queryLogs((QueryBuilder)builder);
    }

    public long getLatestLogId(String repositoryId, String ... eventIds) {
        QueryBuilder builder = new AuditQueryBuilder().predicate(Predicates.eq((String)"repositoryId", (Object)repositoryId)).and(Predicates.in((String)"eventId", (Object[])eventIds)).order(OrderByExprs.desc((String)"id")).limit(1L);
        return this.queryLogs(builder).stream().mapToLong(LogEntry::getId).findFirst().orElse(0L);
    }

    public List<LogEntry> getLogEntriesAfter(long logIdOffset, int limit, String repositoryId, String ... eventIds) {
        QueryBuilder builder = new AuditQueryBuilder().predicate(Predicates.eq((String)"repositoryId", (Object)repositoryId)).and(Predicates.in((String)"eventId", (Object[])eventIds)).and(Predicates.gte((String)"id", (Object)logIdOffset)).order(OrderByExprs.asc((String)"id")).limit((long)limit);
        return this.queryLogs(builder);
    }

    @Override
    public void restore(AuditStorage auditStorage, int batchSize, int keepAlive) {
        AuditQueryBuilder builder = new AuditQueryBuilder();
        ScrollResult scrollResult = auditStorage.scroll((QueryBuilder)builder, batchSize, keepAlive);
        long t0 = System.currentTimeMillis();
        int total = 0;
        log.info("Starting audit restoration");
        while (scrollResult.hasResults()) {
            List jsonEntries = scrollResult.getResults();
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = jsonEntries::size;
            log.debug("Appending {} entries", supplierArray);
            total += jsonEntries.size();
            this.append(jsonEntries);
            double dt = (double)(System.currentTimeMillis() - t0) / 1000.0;
            if (dt != 0.0) {
                log.debug("Restoration speed: {} entries/s", (Object)((double)total / dt));
            }
            scrollResult = auditStorage.scroll(scrollResult.getScrollId());
        }
        log.info("Audit restoration done: {} entries migrated from the audit storage", (Object)total);
    }
}

