/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.commons.io.FileUtils;

public class FileTreeIterator
implements Iterator<File> {
    private final Queue<Iterator<File>> queue = new LinkedList<Iterator<File>>();
    private File file;
    private FileFilter filter;

    public FileTreeIterator(File root) {
        this.queue.add(new OneFileIterator(root));
    }

    public FileTreeIterator(File root, boolean excludeRoot) {
        if (excludeRoot) {
            this.queue.add(new LazyChildrenIterator(root));
        } else {
            this.queue.add(new OneFileIterator(root));
        }
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    @Override
    public boolean hasNext() {
        if (this.queue.isEmpty()) {
            return false;
        }
        Iterator<File> it = this.queue.peek();
        if (it.hasNext()) {
            return true;
        }
        this.queue.poll();
        return this.hasNext();
    }

    @Override
    public File next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more files to iterate over");
        }
        this.file = this.queue.peek().next();
        if (this.file.isDirectory()) {
            this.queue.add(new LazyChildrenIterator(this.file));
        }
        return this.file;
    }

    @Override
    public void remove() {
        if (this.file == null) {
            throw new IllegalStateException("there is no current file to delete");
        }
        FileUtils.deleteQuietly((File)this.file);
    }

    public static void main(String[] args) {
        FileTreeIterator it = new FileTreeIterator(new File("/root/kits"), false);
        while (it.hasNext()) {
            System.out.println(">> " + it.next());
        }
    }

    private class LazyChildrenIterator
    implements Iterator<File> {
        private final File dir;
        private File[] children;
        private int pos = -1;

        private LazyChildrenIterator(File dir) {
            this.dir = dir;
        }

        @Override
        public boolean hasNext() {
            if (this.children == null) {
                File[] fileArray = this.children = FileTreeIterator.this.filter == null ? this.dir.listFiles() : this.dir.listFiles(FileTreeIterator.this.filter);
                if (this.children == null) {
                    return false;
                }
                return this.children.length > 0;
            }
            return this.pos < this.children.length - 1;
        }

        @Override
        public File next() {
            return this.children[++this.pos];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }
    }

    private static class OneFileIterator
    implements Iterator<File> {
        private File file;

        private OneFileIterator(File file) {
            this.file = file;
        }

        @Override
        public boolean hasNext() {
            return this.file != null;
        }

        @Override
        public File next() {
            File next = this.file;
            this.file = null;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }
    }
}

