/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.versioning;

import java.util.List;
import org.nuxeo.ecm.collections.core.adapter.CollectionMember;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.versioning.VersioningPolicyFilter;

public class NoVersioningCollectionPolicyFilter
implements VersioningPolicyFilter {
    public boolean test(DocumentModel previousDocument, DocumentModel currentDocument) {
        if (currentDocument.hasFacet("Collection")) {
            return true;
        }
        if (previousDocument == null) {
            return false;
        }
        boolean previousHasMember = previousDocument.hasSchema("collectionMember");
        boolean currentHashMember = currentDocument.hasSchema("collectionMember");
        if (!previousHasMember && currentHashMember) {
            return true;
        }
        if (previousHasMember && !currentHashMember) {
            return true;
        }
        if (previousHasMember && currentHashMember) {
            List<String> previousMembers = ((CollectionMember)previousDocument.getAdapter(CollectionMember.class)).getCollectionIds();
            List<String> currentMembers = ((CollectionMember)currentDocument.getAdapter(CollectionMember.class)).getCollectionIds();
            return previousMembers.size() != currentMembers.size() || !currentMembers.containsAll(previousMembers);
        }
        return false;
    }
}

