/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.api;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;

public class FileImporterContext {
    protected final CoreSession session;
    protected final Blob blob;
    protected final String parentPath;
    protected String fileName;
    protected boolean overwrite;
    protected boolean mimeTypeCheck;
    protected boolean excludeOneToMany;
    protected boolean persistDocument;

    public static Builder builder(CoreSession session, Blob blob, String parentPath) {
        return new Builder(session, blob, parentPath);
    }

    protected FileImporterContext(Builder builder) {
        this.session = builder.session;
        this.blob = builder.blob;
        this.parentPath = builder.parentPath;
        this.overwrite = builder.overwrite;
        this.mimeTypeCheck = builder.mimeTypeCheck;
        this.excludeOneToMany = builder.excludeOneToMany;
        this.fileName = (String)StringUtils.defaultIfEmpty((CharSequence)builder.fileName, (CharSequence)this.blob.getFilename());
        this.persistDocument = builder.persistDocument;
    }

    public CoreSession getSession() {
        return this.session;
    }

    public Blob getBlob() {
        return this.blob;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isMimeTypeCheck() {
        return this.mimeTypeCheck;
    }

    public boolean isExcludeOneToMany() {
        return this.excludeOneToMany;
    }

    public boolean isPersistDocument() {
        return this.persistDocument;
    }

    public static class Builder {
        protected final CoreSession session;
        protected final Blob blob;
        protected final String parentPath;
        protected String fileName;
        protected boolean overwrite;
        protected boolean mimeTypeCheck = true;
        protected boolean excludeOneToMany;
        protected boolean persistDocument = true;

        public Builder(CoreSession session, Blob blob, String parentPath) {
            this.session = session;
            this.blob = blob;
            this.parentPath = parentPath;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder overwrite(boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        public Builder mimeTypeCheck(boolean mimeTypeCheck) {
            this.mimeTypeCheck = mimeTypeCheck;
            return this;
        }

        public Builder excludeOneToMany(boolean excludeOneToMany) {
            this.excludeOneToMany = excludeOneToMany;
            return this;
        }

        public Builder persistDocument(boolean persistDocument) {
            this.persistDocument = persistDocument;
            return this;
        }

        public FileImporterContext build() {
            return new FileImporterContext(this);
        }
    }
}

