/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.remote.cascading.proxy;

import com.sun.jdmk.remote.cascading.MBeanServerConnectionFactory;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class CascadingProxy
implements DynamicMBean,
MBeanRegistration,
NotificationEmitter {
    private List listenerList;
    private final MBeanServerConnectionFactory connectionFactory;
    private final ObjectName source;
    private ObjectName targetName;

    public CascadingProxy(ObjectName sourceMBeanName, MBeanServerConnectionFactory mbscf) {
        this.connectionFactory = mbscf;
        this.source = sourceMBeanName;
        this.targetName = null;
        this.listenerList = Collections.EMPTY_LIST;
    }

    RuntimeException handleIOException(IOException x, String method) {
        UndeclaredThrowableException r = new UndeclaredThrowableException(x);
        return r;
    }

    RuntimeException handleInstanceNotFoundException(InstanceNotFoundException x, String method) {
        UndeclaredThrowableException r = new UndeclaredThrowableException(x);
        return r;
    }

    RuntimeException handleCheckedException(Exception x, String method) {
        UndeclaredThrowableException r = new UndeclaredThrowableException(x);
        return r;
    }

    private MBeanServerConnection connection() throws IOException {
        MBeanServerConnection c = this.connectionFactory.getMBeanServerConnection();
        if (c == null) {
            throw new IOException("MBeanServerConnection unavailable");
        }
        return c;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            return this.connection().getAttribute(this.source, attribute);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "getAttribute");
        }
        catch (InstanceNotFoundException x) {
            throw this.handleInstanceNotFoundException(x, "getAttribute");
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.connection().setAttribute(this.source, attribute);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "setAttribute");
        }
        catch (InstanceNotFoundException x) {
            throw this.handleInstanceNotFoundException(x, "setAttribute");
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        try {
            return this.connection().getAttributes(this.source, attributes);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "getAttributes");
        }
        catch (InstanceNotFoundException x) {
            throw this.handleInstanceNotFoundException(x, "getAttributes");
        }
        catch (RuntimeException r) {
            throw r;
        }
        catch (Exception x) {
            throw this.handleCheckedException(x, "getAttributes");
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        try {
            return this.connection().setAttributes(this.source, attributes);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "setAttributes");
        }
        catch (InstanceNotFoundException x) {
            throw this.handleInstanceNotFoundException(x, "setAttributes");
        }
        catch (RuntimeException r) {
            throw r;
        }
        catch (Exception x) {
            throw this.handleCheckedException(x, "setAttributes");
        }
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            return this.connection().invoke(this.source, actionName, params, signature);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "invoke");
        }
        catch (InstanceNotFoundException x) {
            throw this.handleInstanceNotFoundException(x, "invoke");
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        try {
            return this.connection().getMBeanInfo(this.source);
        }
        catch (IOException x) {
            throw this.handleIOException(x, "getMBeanInfo");
        }
        catch (InstanceNotFoundException x) {
            throw this.handleInstanceNotFoundException(x, "getMBeanInfo");
        }
        catch (RuntimeException r) {
            throw r;
        }
        catch (Exception x) {
            throw this.handleCheckedException(x, "getMBeanInfo");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("Illegal ObjectName: null");
        }
        CascadingProxy cascadingProxy = this;
        synchronized (cascadingProxy) {
            this.targetName = name;
        }
        return this.targetName;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public final ObjectName getSourceMBeanName() {
        return this.source;
    }

    public synchronized ObjectName getTargetName() {
        return this.targetName;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        try {
            MBeanNotificationInfo[] info = this.getMBeanInfo().getNotifications();
            if (info == null) {
                return new MBeanNotificationInfo[0];
            }
            return info;
        }
        catch (Exception exception) {
            return new MBeanNotificationInfo[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        CascadingProxy cascadingProxy = this;
        synchronized (cascadingProxy) {
            ListenerWrapper w = new ListenerWrapper(listener, filter, handback);
            try {
                this.connection().addNotificationListener(this.source, w, filter, handback);
                ArrayList<ListenerWrapper> newList = new ArrayList<ListenerWrapper>(this.listenerList.size() + 1);
                newList.addAll(this.listenerList);
                newList.add(w);
                this.listenerList = newList;
            }
            catch (IOException x) {
                throw this.handleIOException(x, "addNotificationListener");
            }
            catch (InstanceNotFoundException x) {
                throw this.handleInstanceNotFoundException(x, "addNotificationListener");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        CascadingProxy cascadingProxy = this;
        synchronized (cascadingProxy) {
            ArrayList newList = new ArrayList(this.listenerList);
            int i = newList.size() - 1;
            while (i >= 0) {
                ListenerWrapper li = (ListenerWrapper)newList.get(i);
                if (li.listener == listener) {
                    try {
                        this.connection().removeNotificationListener(this.source, li);
                        newList.remove(i);
                    }
                    catch (IOException x) {
                        throw this.handleIOException(x, "removeNotificationListener");
                    }
                    catch (InstanceNotFoundException x) {
                        throw this.handleInstanceNotFoundException(x, "removeNotificationListener");
                    }
                }
                --i;
            }
            if (newList.size() == this.listenerList.size()) {
                throw new ListenerNotFoundException("Listener not registered");
            }
            this.listenerList = newList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        boolean found = false;
        CascadingProxy cascadingProxy = this;
        synchronized (cascadingProxy) {
            ArrayList newList = new ArrayList(this.listenerList);
            int size = newList.size();
            int i = 0;
            while (i < size) {
                ListenerWrapper li = (ListenerWrapper)newList.get(i);
                if (li.listener == listener) {
                    found = true;
                    if (li.filter == filter && li.handback == handback) {
                        try {
                            this.connection().removeNotificationListener(this.source, li, filter, handback);
                            newList.remove(i);
                        }
                        catch (IOException x) {
                            throw this.handleIOException(x, "removeNotificationListener");
                        }
                        catch (InstanceNotFoundException x) {
                            throw this.handleInstanceNotFoundException(x, "removeNotificationListener");
                        }
                        newList.remove(i);
                        this.listenerList = newList;
                        return;
                    }
                }
                ++i;
            }
        }
        if (found) {
            throw new ListenerNotFoundException("Listener not registered with this filter and handback");
        }
        throw new ListenerNotFoundException("Listener not registered");
    }

    public final MBeanServerConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    protected Notification translate(Notification notif) {
        notif.setSource(this.makeSource(notif.getSource()));
        return notif;
    }

    private Object makeSource(Object source) {
        if (source != null && !source.equals(this.getSourceMBeanName())) {
            return source;
        }
        ObjectName name = this.getTargetName();
        if (name == null) {
            return this;
        }
        return name;
    }

    private final class ListenerWrapper
    implements NotificationListener {
        public final NotificationListener listener;
        final NotificationFilter filter;
        final Object handback;

        public ListenerWrapper(NotificationListener listener, NotificationFilter filter, Object handback) {
            this.listener = listener;
            this.filter = filter;
            this.handback = handback;
        }

        @Override
        public void handleNotification(Notification notif, Object handback) {
            this.listener.handleNotification(CascadingProxy.this.translate(notif), handback);
        }
    }
}

