/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.io;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class RenditionJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String RENDITION_REST_URL_FORMAT = "%sapi/v1/id/%s/@rendition/%s";
    public static final String NAME = "renditions";

    public RenditionJsonEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        RenditionService renditionService = (RenditionService)Framework.getService(RenditionService.class);
        List renditions = renditionService.getAvailableRenditions(document, true);
        jg.writeArrayFieldStart(NAME);
        for (Rendition rendition : renditions) {
            jg.writeStartObject();
            jg.writeStringField("name", rendition.getName());
            jg.writeStringField("kind", rendition.getKind());
            jg.writeStringField("icon", this.ctx.getBaseUrl().replaceAll("/$", "") + rendition.getIcon());
            jg.writeStringField("url", String.format(RENDITION_REST_URL_FORMAT, this.ctx.getBaseUrl(), document.getId(), rendition.getName()));
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }
}

