/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.impl.LiveRendition;
import org.nuxeo.ecm.platform.rendition.impl.StoredRendition;
import org.nuxeo.ecm.platform.rendition.service.DefaultRenditionDescriptor;
import org.nuxeo.ecm.platform.rendition.service.DefaultStoredRenditionManager;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinitionProviderDescriptor;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinitionProviderRegistry;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinitionRegistry;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.ecm.platform.rendition.service.RenditionsRemover;
import org.nuxeo.ecm.platform.rendition.service.StoredRenditionManager;
import org.nuxeo.ecm.platform.rendition.service.StoredRenditionManagerDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class RenditionServiceImpl
extends DefaultComponent
implements RenditionService {
    public static final String RENDITION_DEFINITIONS_EP = "renditionDefinitions";
    public static final String RENDITON_DEFINION_PROVIDERS_EP = "renditionDefinitionProviders";
    public static final String DEFAULT_RENDITION_EP = "defaultRendition";
    public static final String STORED_RENDITION_MANAGERS_EP = "storedRenditionManagers";
    private static final Logger log = LogManager.getLogger(RenditionServiceImpl.class);
    protected RenditionDefinitionRegistry renditionDefinitionRegistry;
    protected RenditionDefinitionProviderRegistry renditionDefinitionProviderRegistry;
    protected List<DefaultRenditionDescriptor> defaultRenditionDescriptors = new ArrayList<DefaultRenditionDescriptor>();
    protected static final StoredRenditionManager DEFAULT_STORED_RENDITION_MANAGER = new DefaultStoredRenditionManager();
    protected Deque<StoredRenditionManagerDescriptor> storedRenditionManagerDescriptors = new LinkedList<StoredRenditionManagerDescriptor>();
    protected final ScriptEngineManager scriptEngineManager = new ScriptEngineManager();

    public StoredRenditionManager getStoredRenditionManager() {
        StoredRenditionManagerDescriptor descr = this.storedRenditionManagerDescriptors.peekLast();
        return descr == null ? DEFAULT_STORED_RENDITION_MANAGER : descr.getStoredRenditionManager();
    }

    public void activate(ComponentContext context) {
        this.renditionDefinitionRegistry = new RenditionDefinitionRegistry();
        this.renditionDefinitionProviderRegistry = new RenditionDefinitionProviderRegistry();
        super.activate(context);
    }

    public void deactivate(ComponentContext context) {
        this.renditionDefinitionRegistry = null;
        this.renditionDefinitionProviderRegistry = null;
        super.deactivate(context);
    }

    @Deprecated(since="10.10")
    public RenditionDefinition getRenditionDefinition(String name) {
        return this.renditionDefinitionRegistry.getRenditionDefinition(name);
    }

    public List<RenditionDefinition> getDeclaredRenditionDefinitions() {
        return new ArrayList<RenditionDefinition>(this.renditionDefinitionRegistry.descriptors.values());
    }

    @Deprecated(since="7.2")
    public List<RenditionDefinition> getDeclaredRenditionDefinitionsForProviderType(String providerType) {
        ArrayList<RenditionDefinition> defs = new ArrayList<RenditionDefinition>();
        for (RenditionDefinition def : this.getDeclaredRenditionDefinitions()) {
            if (!def.getProviderType().equals(providerType)) continue;
            defs.add(def);
        }
        return defs;
    }

    public List<RenditionDefinition> getAvailableRenditionDefinitions(DocumentModel doc) {
        ArrayList<RenditionDefinition> defs = new ArrayList<RenditionDefinition>();
        defs.addAll(this.renditionDefinitionRegistry.getRenditionDefinitions(doc));
        defs.addAll(this.renditionDefinitionProviderRegistry.getRenditionDefinitions(doc));
        return defs;
    }

    public DocumentRef storeRendition(DocumentModel source, String renditionDefinitionName) {
        Rendition rendition = this.getRendition(source, renditionDefinitionName, true);
        return rendition == null ? null : rendition.getHostDocument().getRef();
    }

    @Deprecated(since="8.1")
    protected DocumentModel storeRendition(DocumentModel sourceDocument, Rendition rendition, String name) {
        StoredRendition storedRendition = this.storeRendition(sourceDocument, rendition);
        return storedRendition == null ? null : storedRendition.getHostDocument();
    }

    @Deprecated(since="10.10")
    protected StoredRendition storeRendition(DocumentModel sourceDocument, Rendition rendition) {
        RenditionDefinition renditionDefinition = this.getAvailableRenditionDefinition(sourceDocument, rendition.getName());
        return this.storeRendition(sourceDocument, rendition, renditionDefinition);
    }

    protected StoredRendition storeRendition(DocumentModel sourceDocument, Rendition rendition, RenditionDefinition renditionDefinition) {
        if (!rendition.isCompleted()) {
            log.debug("Incomplete rendition for source document {}.", (Object)sourceDocument);
            return null;
        }
        List renderedBlobs = rendition.getBlobs();
        if (CollectionUtils.isEmpty((Collection)renderedBlobs)) {
            log.debug("No rendition blobs for source document {}.", (Object)sourceDocument);
            return null;
        }
        Blob renderedBlob = (Blob)renderedBlobs.get(0);
        String mimeType = renderedBlob.getMimeType();
        if (mimeType != null && (mimeType.contains("error=true") || mimeType.contains("stale=true"))) {
            log.debug("Rendition has MIME type {} for source document {}.", (Object)mimeType, (Object)sourceDocument);
            return null;
        }
        CoreSession session = sourceDocument.getCoreSession();
        DocumentModel version = null;
        boolean isVersionable = sourceDocument.isVersionable();
        if (sourceDocument.isVersion()) {
            version = sourceDocument;
            sourceDocument = session.getDocument((DocumentRef)new IdRef(version.getSourceId()));
        } else if (isVersionable) {
            DocumentRef versionRef = this.createVersionIfNeeded(sourceDocument, session);
            version = session.getDocument(versionRef);
        }
        log.debug("Creating stored rendition for source document {}.", (Object)sourceDocument);
        return this.getStoredRenditionManager().createStoredRendition(sourceDocument, version, renderedBlob, renditionDefinition);
    }

    protected DocumentRef createVersionIfNeeded(DocumentModel source, CoreSession session) {
        if (source.isVersionable()) {
            if (source.isVersion()) {
                return source.getRef();
            }
            if (source.isCheckedOut()) {
                DocumentRef versionRef = session.checkIn(source.getRef(), VersioningOption.MINOR, null);
                source.refresh(1, null);
                return versionRef;
            }
            return session.getLastDocumentVersionRef(source.getRef());
        }
        return null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (RENDITION_DEFINITIONS_EP.equals(extensionPoint)) {
            RenditionDefinition renditionDefinition = (RenditionDefinition)contribution;
            this.renditionDefinitionRegistry.addContribution(renditionDefinition);
        } else if (RENDITON_DEFINION_PROVIDERS_EP.equals(extensionPoint)) {
            this.renditionDefinitionProviderRegistry.addContribution((RenditionDefinitionProviderDescriptor)contribution);
        } else if (STORED_RENDITION_MANAGERS_EP.equals(extensionPoint)) {
            this.storedRenditionManagerDescriptors.add((StoredRenditionManagerDescriptor)contribution);
        } else if (DEFAULT_RENDITION_EP.equals(extensionPoint)) {
            this.defaultRenditionDescriptors.add((DefaultRenditionDescriptor)contribution);
        }
    }

    protected RenditionDefinition mergeRenditions(RenditionDefinition oldRenditionDefinition, RenditionDefinition newRenditionDefinition) {
        String operationChain;
        String label = newRenditionDefinition.getLabel();
        if (label != null) {
            oldRenditionDefinition.label = label;
        }
        if ((operationChain = newRenditionDefinition.getOperationChain()) != null) {
            oldRenditionDefinition.operationChain = operationChain;
        }
        return oldRenditionDefinition;
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (RENDITION_DEFINITIONS_EP.equals(extensionPoint)) {
            this.renditionDefinitionRegistry.removeContribution((RenditionDefinition)contribution);
        } else if (RENDITON_DEFINION_PROVIDERS_EP.equals(extensionPoint)) {
            this.renditionDefinitionProviderRegistry.removeContribution((RenditionDefinitionProviderDescriptor)contribution);
        } else if (STORED_RENDITION_MANAGERS_EP.equals(extensionPoint)) {
            this.storedRenditionManagerDescriptors.remove(contribution);
        } else if (DEFAULT_RENDITION_EP.equals(extensionPoint)) {
            this.defaultRenditionDescriptors.remove(contribution);
        }
    }

    public Rendition getRendition(DocumentModel doc, String renditionName) {
        RenditionDefinition renditionDefinition = this.getAvailableRenditionDefinition(doc, renditionName);
        return this.getRendition(doc, renditionDefinition, renditionDefinition.isStoreByDefault());
    }

    public Rendition getRendition(DocumentModel doc, String renditionName, boolean store) {
        RenditionDefinition renditionDefinition = this.getAvailableRenditionDefinition(doc, renditionName);
        return this.getRendition(doc, renditionDefinition, store);
    }

    protected Optional<Rendition> getRenditionSafe(DocumentModel doc, String defaultRenditionName, boolean store) {
        try {
            return Optional.of(this.getRendition(doc, defaultRenditionName, store));
        }
        catch (NuxeoException e) {
            log.error("Unable to use default rendition: {}", (Object)defaultRenditionName, (Object)e);
            return Optional.empty();
        }
    }

    protected Rendition getRendition(DocumentModel doc, RenditionDefinition renditionDefinition, boolean store) {
        StoredRendition rendition;
        boolean isVersionable = doc.isVersionable();
        if (!isVersionable || !doc.isCheckedOut()) {
            log.debug("Document {} is not versionable nor checked out, trying to find a stored rendition.", (Object)doc);
            rendition = this.getStoredRenditionManager().findStoredRendition(doc, renditionDefinition);
            if (rendition != null) {
                log.debug("Found and returning a stored rendition for document {}.", (Object)doc);
                return rendition;
            }
            log.debug("Found no stored rendition for document {}.", (Object)doc);
        } else {
            log.debug("Document {} is versionable and checked out, not trying to find any stored rendition.", (Object)doc);
        }
        rendition = new LiveRendition(doc, renditionDefinition);
        if (store) {
            StoredRendition storedRendition = this.storeRendition(doc, (Rendition)rendition, renditionDefinition);
            if (storedRendition != null) {
                log.debug("Returning new stored rendition for document {}.", (Object)doc);
                return storedRendition;
            }
            log.debug("No rendition stored for document {}, returning live rendition.", (Object)doc);
        } else {
            log.debug("Returning live rendition for document {}.", (Object)doc);
        }
        return rendition;
    }

    public RenditionDefinition getAvailableRenditionDefinition(DocumentModel doc, String renditionName) {
        RenditionDefinition renditionDefinition = this.renditionDefinitionRegistry.getRenditionDefinition(renditionName);
        if (renditionDefinition == null) {
            renditionDefinition = this.renditionDefinitionProviderRegistry.getRenditionDefinition(renditionName, doc);
            if (renditionDefinition == null) {
                String message = "The rendition definition '%s' is not registered";
                throw new NuxeoException(String.format(message, renditionName));
            }
        } else if (!this.renditionDefinitionRegistry.canUseRenditionDefinition(renditionDefinition, doc)) {
            throw new NuxeoException("Rendition " + renditionName + " cannot be used for this doc " + doc.getId());
        }
        if (renditionDefinition.getProvider() == null) {
            throw new NuxeoException(String.format("Rendition definition %s isn't bound to any rendition provider", renditionName));
        }
        if (!renditionDefinition.getProvider().isAvailable(doc, renditionDefinition)) {
            throw new NuxeoException(String.format("Rendition %s not available for this doc %s", renditionName, doc.getPathAsString()));
        }
        return renditionDefinition;
    }

    public List<Rendition> getAvailableRenditions(DocumentModel doc) {
        return this.getAvailableRenditions(doc, false);
    }

    public List<Rendition> getAvailableRenditions(DocumentModel doc, boolean onlyVisible) {
        ArrayList<Rendition> renditions = new ArrayList<Rendition>();
        List<RenditionDefinition> defs = this.getAvailableRenditionDefinitions(doc);
        if (defs != null) {
            for (RenditionDefinition def : defs) {
                Rendition rendition;
                if (onlyVisible && !def.isVisible() || (rendition = this.getRendition(doc, def.getName(), false)) == null) continue;
                renditions.add(rendition);
            }
        }
        return renditions;
    }

    public void deleteStoredRenditions(String repositoryName) {
        StoredRenditionsCleaner cleaner = new StoredRenditionsCleaner(repositoryName);
        cleaner.runUnrestricted();
    }

    public Rendition getDefaultRendition(DocumentModel doc, String reason, Map<String, Serializable> extendedInfos) {
        return this.getDefaultRendition(doc, reason, false, extendedInfos);
    }

    public Rendition getDefaultRendition(DocumentModel doc, String reason, boolean store, Map<String, Serializable> extendedInfos) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Map<Object, Object> ei = extendedInfos == null ? Collections.emptyMap() : extendedInfos;
        NuxeoPrincipal currentUser = NuxeoPrincipal.getCurrent();
        context.put("Document", doc);
        context.put("Infos", ei);
        context.put("CurrentUser", currentUser);
        ScriptEngine engine = null;
        for (int i = this.defaultRenditionDescriptors.size() - 1; i >= 0; --i) {
            DefaultRenditionDescriptor desc = this.defaultRenditionDescriptors.get(i);
            if ((!StringUtils.isEmpty((CharSequence)reason) || !StringUtils.isEmpty((CharSequence)desc.reason)) && (reason == null || !reason.equals(desc.reason))) continue;
            String scriptLanguage = desc.getScriptLanguage();
            if (!(engine != null && engine.getFactory().getNames().contains(scriptLanguage) || (engine = this.scriptEngineManager.getEngineByName(scriptLanguage)) != null)) {
                throw new NuxeoException("Engine not found for language: " + scriptLanguage);
            }
            if (!(engine instanceof Invocable)) {
                throw new NuxeoException("Engine " + engine.getClass().getName() + " not Invocable for language: " + scriptLanguage);
            }
            try {
                Optional<Rendition> rendition;
                engine.eval(desc.getScript());
                engine.getBindings(100).putAll((Map<? extends String, ? extends Object>)context);
                Object result = ((Invocable)((Object)engine)).invokeFunction("run", new Object[0]);
                if (result == null && desc.override) break;
                String defaultRenditionName = (String)result;
                if (StringUtils.isBlank((CharSequence)defaultRenditionName) || !(rendition = this.getRenditionSafe(doc, defaultRenditionName, store)).isPresent()) continue;
                return rendition.get();
            }
            catch (NoSuchMethodException e) {
                throw new NuxeoException("Script does not contain function: run() in defaultRendition: ", (Throwable)e);
            }
            catch (ScriptException e) {
                log.error("Failed to evaluate script: ", (Throwable)e);
            }
        }
        log.warn("Failed to get rendition name for reason {}", (Object)reason);
        return null;
    }

    public DocumentModel publishRendition(DocumentModel doc, DocumentModel target, String renditionName, boolean override) {
        Rendition rendition;
        CoreSession session = doc.getCoreSession();
        if (!session.hasPermission(target.getRef(), "AddChildren")) {
            log.error("Permission '{}' is not granted to '{}' on document '{}'", (Object)"AddChildren", (Object)session.getPrincipal().getName(), (Object)target.getPath());
            throw new DocumentSecurityException("Privilege 'AddChildren' is not granted to '" + session.getPrincipal().getName() + "'");
        }
        Rendition rendition2 = rendition = StringUtils.isEmpty((CharSequence)renditionName) ? this.getDefaultRendition(doc, "publish", true, null) : this.getRendition(doc, renditionName, true);
        if (rendition == null) {
            throw new NuxeoException("Unable to render the document");
        }
        DocumentModel renditionDocument = rendition.getHostDocument();
        DocumentRef publishedDocumentRef = (DocumentRef)CoreInstance.doPrivileged((CoreSession)session, s -> s.publishDocument(renditionDocument, target, override).getRef());
        DocumentModel publishedDocument = session.getDocument(publishedDocumentRef);
        if (override) {
            RenditionsRemover remover = new RenditionsRemover(publishedDocument);
            remover.runUnrestricted();
        }
        return publishedDocument;
    }

    private final class StoredRenditionsCleaner
    extends UnrestrictedSessionRunner {
        private static final int BATCH_SIZE = 100;

        private StoredRenditionsCleaner(String repositoryName) {
            super(repositoryName);
        }

        public void run() {
            Map<String, List<String>> sourceIdToRenditionRefs = this.computeLiveDocumentRefsToRenditionRefs();
            this.removeStoredRenditions(sourceIdToRenditionRefs);
        }

        private Map<String, List<String>> computeLiveDocumentRefsToRenditionRefs() {
            HashMap<String, List<String>> liveDocumentRefsToRenditionRefs = new HashMap<String, List<String>>();
            String query = String.format("SELECT %s, %s, %s FROM Document WHERE %s IS NOT NULL AND ecm:isVersion = 0", "ecm:uuid", "rend:sourceId", "rend:sourceVersionableId", "rend:sourceId");
            try (IterableQueryResult result = this.session.queryAndFetch(query, "NXQL", new Object[0]);){
                for (Map res : result) {
                    String renditionRef = ((Serializable)res.get("ecm:uuid")).toString();
                    String sourceId = ((Serializable)res.get("rend:sourceId")).toString();
                    Serializable sourceVersionableId = (Serializable)res.get("rend:sourceVersionableId");
                    String key = sourceVersionableId != null ? sourceVersionableId.toString() : sourceId;
                    liveDocumentRefsToRenditionRefs.computeIfAbsent(key, k -> new ArrayList()).add(renditionRef);
                }
            }
            return liveDocumentRefsToRenditionRefs;
        }

        private void removeStoredRenditions(Map<String, List<String>> liveDocumentRefsToRenditionRefs) {
            ArrayList<String> liveDocumentRefs = new ArrayList<String>(liveDocumentRefsToRenditionRefs.keySet());
            if (liveDocumentRefs.isEmpty()) {
                return;
            }
            for (int processedSourceIds = 0; processedSourceIds < liveDocumentRefs.size(); processedSourceIds += 100) {
                int limit = processedSourceIds + 100 > liveDocumentRefs.size() ? liveDocumentRefs.size() : processedSourceIds + 100;
                List batchSourceIds = liveDocumentRefs.subList(processedSourceIds, limit);
                ArrayList existingSourceIds = new ArrayList();
                String query = NXQLQueryBuilder.getQuery((String)"SELECT ecm:uuid FROM Document WHERE ecm:uuid IN ?", (Object[])new Object[]{batchSourceIds}, (boolean)true, (boolean)true, null, (SortInfo[])new SortInfo[0]);
                try (IterableQueryResult result = this.session.queryAndFetch(query, "NXQL", new Object[0]);){
                    result.forEach(res -> existingSourceIds.add(((Serializable)res.get("ecm:uuid")).toString()));
                }
                batchSourceIds.removeAll(existingSourceIds);
                List renditionRefsToDelete = batchSourceIds.stream().map(liveDocumentRefsToRenditionRefs::get).reduce(new ArrayList(), (allRefs, refs) -> {
                    allRefs.addAll(refs);
                    return allRefs;
                });
                if (!renditionRefsToDelete.isEmpty()) {
                    this.session.removeDocuments((DocumentRef[])renditionRefsToDelete.stream().map(IdRef::new).toArray(DocumentRef[]::new));
                }
                if (!TransactionHelper.isTransactionActiveOrMarkedRollback()) continue;
                TransactionHelper.commitOrRollbackTransaction();
                TransactionHelper.startTransaction();
            }
        }
    }
}

