/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.ui;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.nuxeo.connect.client.ui.ListingFilterSetting;
import org.nuxeo.ecm.platform.web.common.RequestContext;

public class SharedPackageListingsSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, RequestResolver> resolvers = new ConcurrentHashMap<String, RequestResolver>();
    protected Map<String, ListingFilterSetting> settings = new HashMap<String, ListingFilterSetting>();
    public static final String SESSION_KEY = "org.nuxeo.connect.client.ui.PackageListingSettings";

    public static void addRequestResolver(RequestResolver resolver) {
        resolvers.put(resolver.getId(), resolver);
    }

    public static void removeRequestResolver(String id) {
        resolvers.remove(id);
    }

    public ListingFilterSetting get(String listName) {
        if (!this.settings.containsKey(listName)) {
            this.settings.put(listName, new ListingFilterSetting());
        }
        return this.settings.get(listName);
    }

    public static SharedPackageListingsSettings instance() {
        return resolvers.values().stream().filter(RequestResolver::isActive).findFirst().map(RequestResolver::resolve).map(SharedPackageListingsSettings::instance).orElse(null);
    }

    public static SharedPackageListingsSettings instance(HttpServletRequest request) {
        return SharedPackageListingsSettings.instance(request.getSession(true));
    }

    public static SharedPackageListingsSettings instance(HttpSession session) {
        Object val = session.getAttribute(SESSION_KEY);
        if (val == null || !(val instanceof SharedPackageListingsSettings)) {
            val = new SharedPackageListingsSettings();
            session.setAttribute(SESSION_KEY, val);
        }
        return (SharedPackageListingsSettings)val;
    }

    static {
        SharedPackageListingsSettings.addRequestResolver(new RequestResolver(){

            @Override
            public boolean isActive() {
                return RequestContext.getActiveContext() != null;
            }

            @Override
            public HttpServletRequest resolve() {
                return RequestContext.getActiveContext().getRequest();
            }

            @Override
            public String getId() {
                return "webengine";
            }
        });
    }

    public static interface RequestResolver {
        public boolean isActive();

        public HttpServletRequest resolve();

        public String getId();
    }
}

